#!/usr/bin/env perl

use strict;
use warnings;
use utf8;
use FindBin;
use lib "$FindBin::Bin/../../lib";
use Data::Dumper::AutoEncode;
use Encode qw/encode_utf8/;
use Number::Phone::JP::AreaCode::MasterData::TSV2Hash;

$Data::Dumper::Terse  = 1;
$Data::Dumper::Indent = 1;
$Data::Dumper::Deepcopy = 1;

my $tsv_file    = $ARGV[0];
my $is_generate = $ARGV[1];

$Data::Dumper::Sortkeys = sub {
    my ($hash) = @_;
    return [sort keys %$hash];
};

my $tsv2hash = Number::Phone::JP::AreaCode::MasterData::TSV2Hash->new();
my $hashref_str = eDumper($tsv2hash->parse_tsv_file($tsv_file));

if ($is_generate) {
    chomp $hashref_str;

    open my $fh, '>', "$FindBin::Bin/../../../lib/Number/Phone/JP/AreaCode/Data/Address2AreaCode.pm";
    print $fh <<"...";
package Number::Phone::JP::AreaCode::Data::Address2AreaCode;

### AUTO GENERATED BY `generate_address2areacode.pl`
### *** DO NOT EDIT THIS FILE WITH MANUAL LABOR ***

use strict;
use warnings;
use utf8;
use parent qw/Exporter/;

our \@EXPORT = qw/get_address2areacode_map/;

use constant ADDRESS_TO_AREACODE_MAP =>
$hashref_str;

sub get_address2areacode_map {
    return ADDRESS_TO_AREACODE_MAP;
}

1;
__END__

=encoding utf-8

=head1 NAME

Number::Phone::JP::AreaCode::Data::Address2AreaCode - Provides Address to Area Code Map of Japanese Area Code of Phone

=head1 SYNOPSIS

    package Number::Phone::JP::AreaCode::Data::Address2AreaCode;

    my \$address2areacode_map = get_address2areacode_map;

=head1 DESCRIPTION

This module provides address to area code map of Japanese area code of phone.

=head1 FUNCTIONS

=over 4

=item * get_address2areacode_map

Returns address to area code map as hash reference.

=back

=head1 LICENSE

Copyright (C) moznion.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

...
}
else {
    print $hashref_str;
}
