use strict;
use warnings;
use utf8;
use Test::More;
use Test::Pretty;
use Test::Base::Less;
use Acme::VOYAGEGROUP::ConferenceRoom;

subtest '会議室の場所が確認できる' => sub {
    filters {
        expected => [qw/chomp/],
    };
    for my $block (blocks) {
        is conference_room($block->input, 'none'), $block->expected, $block->input . 'が正しく表示できるか';
    }
};



done_testing;

__DATA__

=== PANGEA
--- input: pangea
--- expected
.---------------.---------------------.
|///////////////|                     |
|///////////////|      .--.--.----.---|
|///////////////|      |  |  |    |   |
|///////////////|---.  |  |--|    |   |
|///////////////|   |  '--'  '----|   |
|///////////////|---'-.          .'---|
|///////////////|     |          |    |
'---------------'-----'.--.--.  .'----|
                       |     |  |     |
                       |--.--|  |--.--|
                       |  |  |  |  |  |
                       '--'--'  '--'--|
                                      |
                         .------------|
                         |            |
                         |            |
                         '------------'
=== MEGALLANICA
--- input: megallanica
--- expected
.---------------.---------------------.
|               |                     |
|               |      .--.--.----.---|
|               |      |//|  |    |   |
|               |---.  |//|--|    |   |
|               |   |  '--'  '----|   |
|               |---'-.          .'---|
|               |     |          |    |
'---------------'-----'.--.--.  .'----|
                       |     |  |     |
                       |--.--|  |--.--|
                       |  |  |  |  |  |
                       '--'--'  '--'--|
                                      |
                         .------------|
                         |            |
                         |            |
                         '------------'
=== MU
--- input: mu
--- expected
.---------------.---------------------.
|               |                     |
|               |      .--.--.----.---|
|               |      |  |//|    |   |
|               |---.  |  |--|    |   |
|               |   |  '--'  '----|   |
|               |---'-.          .'---|
|               |     |          |    |
'---------------'-----'.--.--.  .'----|
                       |     |  |     |
                       |--.--|  |--.--|
                       |  |  |  |  |  |
                       '--'--'  '--'--|
                                      |
                         .------------|
                         |            |
                         |            |
                         '------------'
=== ULITIMA
--- input: ultima
--- expected
.---------------.---------------------.
|               |                     |
|               |      .--.--.----.---|
|               |      |  |  |    |   |
|               |---.  |  |--|    |   |
|               |///|  '--'  '----|   |
|               |---'-.          .'---|
|               |     |          |    |
'---------------'-----'.--.--.  .'----|
                       |     |  |     |
                       |--.--|  |--.--|
                       |  |  |  |  |  |
                       '--'--'  '--'--|
                                      |
                         .------------|
                         |            |
                         |            |
                         '------------'
=== ATLANTIS
--- input: atlantis
--- expected
.---------------.---------------------.
|               |                     |
|               |      .--.--.----.---|
|               |      |  |  |////|   |
|               |---.  |  |--|////|   |
|               |   |  '--'  '----|   |
|               |---'-.          .'---|
|               |     |          |    |
'---------------'-----'.--.--.  .'----|
                       |     |  |     |
                       |--.--|  |--.--|
                       |  |  |  |  |  |
                       '--'--'  '--'--|
                                      |
                         .------------|
                         |            |
                         |            |
                         '------------'
=== PACIFIS
--- input: pacifis
--- expected
.---------------.---------------------.
|               |                     |
|               |      .--.--.----.---|
|               |      |  |  |    |///|
|               |---.  |  |--|    |///|
|               |   |  '--'  '----|///|
|               |---'-.          .'---|
|               |     |          |    |
'---------------'-----'.--.--.  .'----|
                       |     |  |     |
                       |--.--|  |--.--|
                       |  |  |  |  |  |
                       '--'--'  '--'--|
                                      |
                         .------------|
                         |            |
                         |            |
                         '------------'
=== ZIPANG
--- input: zipang
--- expected
.---------------.---------------------.
|               |                     |
|               |      .--.--.----.---|
|               |      |  |  |    |   |
|               |---.  |  |--|    |   |
|               |   |  '--'  '----|   |
|               |---'-.          .'---|
|               |/////|          |    |
'---------------'-----'.--.--.  .'----|
                       |     |  |     |
                       |--.--|  |--.--|
                       |  |  |  |  |  |
                       '--'--'  '--'--|
                                      |
                         .------------|
                         |            |
                         |            |
                         '------------'
=== LEMURIA
--- input: lemuria
--- expected
.---------------.---------------------.
|               |                     |
|               |      .--.--.----.---|
|               |      |  |  |    |   |
|               |---.  |  |--|    |   |
|               |   |  '--'  '----|   |
|               |---'-.          .'---|
|               |     |          |////|
'---------------'-----'.--.--.  .'----|
                       |     |  |     |
                       |--.--|  |--.--|
                       |  |  |  |  |  |
                       '--'--'  '--'--|
                                      |
                         .------------|
                         |            |
                         |            |
                         '------------'
=== AFRICA
--- input: africa
--- expected
.---------------.---------------------.
|               |                     |
|               |      .--.--.----.---|
|               |      |  |  |    |   |
|               |---.  |  |--|    |   |
|               |   |  '--'  '----|   |
|               |---'-.          .'---|
|               |     |          |    |
'---------------'-----'.--.--.  .'----|
                       |/////|  |     |
                       |--.--|  |--.--|
                       |  |  |  |  |  |
                       '--'--'  '--'--|
                                      |
                         .------------|
                         |            |
                         |            |
                         '------------'
=== EURASIA
--- input: eurasia
--- expected
.---------------.---------------------.
|               |                     |
|               |      .--.--.----.---|
|               |      |  |  |    |   |
|               |---.  |  |--|    |   |
|               |   |  '--'  '----|   |
|               |---'-.          .'---|
|               |     |          |    |
'---------------'-----'.--.--.  .'----|
                       |     |  |/////|
                       |--.--|  |--.--|
                       |  |  |  |  |  |
                       '--'--'  '--'--|
                                      |
                         .------------|
                         |            |
                         |            |
                         '------------'
=== NORTH_AMERICA
--- input: north_america
--- expected
.---------------.---------------------.
|               |                     |
|               |      .--.--.----.---|
|               |      |  |  |    |   |
|               |---.  |  |--|    |   |
|               |   |  '--'  '----|   |
|               |---'-.          .'---|
|               |     |          |    |
'---------------'-----'.--.--.  .'----|
                       |     |  |     |
                       |--.--|  |--.--|
                       |  |  |  |  |//|
                       '--'--'  '--'--|
                                      |
                         .------------|
                         |            |
                         |            |
                         '------------'
=== SOUTH_AMERICA
--- input: south_america
--- expected
.---------------.---------------------.
|               |                     |
|               |      .--.--.----.---|
|               |      |  |  |    |   |
|               |---.  |  |--|    |   |
|               |   |  '--'  '----|   |
|               |---'-.          .'---|
|               |     |          |    |
'---------------'-----'.--.--.  .'----|
                       |     |  |     |
                       |--.--|  |--.--|
                       |  |  |  |//|  |
                       '--'--'  '--'--|
                                      |
                         .------------|
                         |            |
                         |            |
                         '------------'
=== AUSTRALLIA
--- input: australlia
--- expected
.---------------.---------------------.
|               |                     |
|               |      .--.--.----.---|
|               |      |  |  |    |   |
|               |---.  |  |--|    |   |
|               |   |  '--'  '----|   |
|               |---'-.          .'---|
|               |     |          |    |
'---------------'-----'.--.--.  .'----|
                       |     |  |     |
                       |--.--|  |--.--|
                       |  |//|  |  |  |
                       '--'--'  '--'--|
                                      |
                         .------------|
                         |            |
                         |            |
                         '------------'
=== ANTARCTICA
--- input: antarctica
--- expected
.---------------.---------------------.
|               |                     |
|               |      .--.--.----.---|
|               |      |  |  |    |   |
|               |---.  |  |--|    |   |
|               |   |  '--'  '----|   |
|               |---'-.          .'---|
|               |     |          |    |
'---------------'-----'.--.--.  .'----|
                       |     |  |     |
                       |--.--|  |--.--|
                       |//|  |  |  |  |
                       '--'--'  '--'--|
                                      |
                         .------------|
                         |            |
                         |            |
                         '------------'
=== AJITO
--- input: ajito
--- expected
.---------------.---------------------.
|               |                     |
|               |      .--.--.----.---|
|               |      |  |  |    |   |
|               |---.  |  |--|    |   |
|               |   |  '--'  '----|   |
|               |---'-.          .'---|
|               |     |          |    |
'---------------'-----'.--.--.  .'----|
                       |     |  |     |
                       |--.--|  |--.--|
                       |  |  |  |  |  |
                       '--'--'  '--'--|
                                      |
                         .------------|
                         |////////////|
                         |////////////|
                         '------------'
