/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.expression;

import java.util.Iterator;
import java.util.List;
import opennlp.common.synsem.Category;
import opennlp.common.synsem.LF;
import opennlp.common.unify.Unifier;
import opennlp.common.unify.UnifyFailure;
import opennlp.grok.expression.AbstractCat;
import opennlp.grok.expression.AtomCat;
import opennlp.grok.expression.BasicArg;
import opennlp.grok.expression.CurriedCat;
import opennlp.grok.expression.Slash;
import opennlp.grok.expression.TargetCat;
import opennlp.grok.expression.VarCat;
import opennlp.grok.io.LexiconReader;
import opennlp.hylo.HyloHelper;
import org.jdom.Element;

public class CatReader {
    public static Category getCat(Element catel) {
        AbstractCat cat = null;
        String catType = catel.getName();
        if (catType.equals("ac")) {
            cat = new AtomCat(catel);
        } else if (catType.equals("cc")) {
            cat = new CurriedCat(catel);
        } else if (catType.equals("v")) {
            cat = new VarCat(catel);
        } else {
            if (catType.equals("ec")) {
                String parent = catel.getAttributeValue("parent");
                Category pcat = (Category)LexiconReader.cathash.get(parent);
                List ecEls = catel.getChildren();
                pcat = pcat.copy();
                Iterator toAdd = ecEls.iterator();
                CatReader.mergeLF(pcat, HyloHelper.getLF((Element)((Element)toAdd.next())));
                Slash addSlash = new Slash((Element)toAdd.next());
                Category addCat = CatReader.getCat((Element)toAdd.next());
                BasicArg arg = new BasicArg(addSlash, addCat);
                if (pcat instanceof CurriedCat) {
                    ((CurriedCat)pcat).add(arg);
                } else {
                    pcat = new CurriedCat((TargetCat)pcat, arg);
                }
                return pcat;
            }
            if (catType.equals("cat")) {
                String ref = catel.getAttributeValue("ref");
                return (Category)LexiconReader.cathash.get(ref);
            }
        }
        return cat;
    }

    public static void mergeLF(Category c, LF lf) {
        if (c instanceof AtomCat) {
            AtomCat ac = (AtomCat)c;
            LF original = ac.getLF();
            try {
                ac.setLF((LF)Unifier.unify((Object)original, (Object)lf));
            }
            catch (UnifyFailure uf) {}
        } else if (c instanceof CurriedCat) {
            CurriedCat cc = (CurriedCat)c;
            CatReader.mergeLF(((CurriedCat)c).getResult(), lf);
        }
    }
}

