# NAME

Catmandu::Fix::LIDO - Implement LIDO fixes

# SYNOPSIS

A set of fixes for the Catmandu project to convert data to the LIDO XML format.

These fixes generate a data structure that can be exported to XML using the Catmandu LIDO exporter.

# MODULES

- [Catmandu::Fix::lido\_baseid](https://metacpan.org/pod/Catmandu::Fix::lido_baseid)
- [Catmandu::Fix::lido\_basenameset](https://metacpan.org/pod/Catmandu::Fix::lido_basenameset)
- [Catmandu::Fix::lido\_basevalue](https://metacpan.org/pod/Catmandu::Fix::lido_basevalue)
- [Catmandu::Fix::lido\_term](https://metacpan.org/pod/Catmandu::Fix::lido_term)
- [Catmandu::Fix::lido\_date](https://metacpan.org/pod/Catmandu::Fix::lido_date)
- [Catmandu::Fix::lido\_descriptivenote](https://metacpan.org/pod/Catmandu::Fix::lido_descriptivenote)

- [Catmandu::Fix::lido\_classification](https://metacpan.org/pod/Catmandu::Fix::lido_classification)
- [Catmandu::Fix::lido\_inscription](https://metacpan.org/pod/Catmandu::Fix::lido_inscription)
- [Catmandu::Fix::lido\_objectmeasurements](https://metacpan.org/pod/Catmandu::Fix::lido_objectmeasurements)
- [Catmandu::Fix::lido\_actor](https://metacpan.org/pod/Catmandu::Fix::lido_actor)

# DESCRIPTION

A set of [fixes](http://librecat.org/Catmandu/#fixes-cheat-sheet) for the [Catmandu project](http://librecat.org/) to convert data to the [LIDO XML](http://lido-schema.org/) format. The output is usable as input to the [Catmandu LIDO exporter](https://github.com/LibreCat/Catmandu-LIDO).

The fixes consist of two types: six building block fixes, that create generic LIDO-compatible elements at a given position (path) in the result, and four specific fixes that create blocks of LIDO at a predefined location.

It is possible to use only the six block fixes to generate an entire, valid, LIDO record, but for ease of use the four specific fixes have been provided to lighten the load in your `.fix` file.

To use the block fixes, you must provide the path where they should appear.

Note that all parameters prefixed by `-` are optional.

Also take note that `descriptiveMetadata` and `administrativeMetadata` must have a `lang` attribute you must set yourself (e.g. via `add_field`), otherwise your LIDO records will not be valid.

## Block fixes

### `lido_baseid`

Will generate all components for a valid ID-type node in a path. You must provide the parent of the ID-type node as part of the path.

```
	lido_baseid(
        path, # The path where the component will appear (includes the parent).
		id_value, # The value of the ID, as a path.
		-type: ID.type, # String.
		-source: ID.source, # String.
		-label: ID.label # String.
	)
```


### `lido_basenameset`

Will generate all components for a `appellationValue`-`sourceAppellation` pair in a path. The parent of the node pair (e.g. `titleSet`) must be provided as part of the path.

```
    lido_basenameset (
        path, # The path where the component will appear (includes the parent).
        value, # Value of appellationValue, as path.
        -value_pref: appellationValue.pref, # String.
        -value_lang: appellationValue.lang, # String.
        -source: sourceAppellation, # Value of sourceAppellation, as path.
        -source_lang: sourceAppellation.lang # String.
    )
```

### `lido_basevalue`

Will generate all components for a simple parent => value node in a path. The parent part must be provided as part of the path.

```
    lido_basevalue(
        path, # The path where the component will appear (includes the parent).
        value, # Value, as path.
        -pref: node.pref, # String.
        -lang: node.lang, # String.
        -label: node.label, # String.
        -type: node.type # String.
    )
```

### `lido_term`

Will generate all components for a `term`-`conceptID` pair in a path. The parent of the node pair (e.g. `category`) must be provided as part of the path.

```
    lido_term(
        path, # The path where the components will appear (includes the parent).
        term, # The value of the term component, as path.
        -conceptid: conceptID, # The value of the conceptID component, as path.
        -lang: term.lang, # String
        -pref: term.pref, # String
        -source: conceptID.source, # String
        -type: conceptID.type # String
    )
```

### `lido_date`

Will create a `earliestDate`-`latestDate` pair in a path. The parent of the pair must be provided as part of the path.

```
    lido_date(
        path, # The path where the components will appear (includes the parent).
        -earliest_date: earliestDate, # Value of earliestDate, as path.
        -latest_date: latestDate # Value of latestDate, as path.
    )
```

### `lido_descriptivenote`

Create a `descriptiveNoteValue` node in a path. Include the parent in the path, but not `descriptiveNoteValue`; this will be generated by this fix.

```
    lido_descriptivenote(
        path, # The path where the component will appear.
        value, # Value, as path.
        -lang: descriptiveNoteValue.lang, # String.
        -label: descriptiveNoteValue.label # String.
    )
```

## Specific fixes

It is possible to create the nodes these fixes generate by using only the blocks above. However, for basic use cases, the fixes below will be easier. These fixes will also automatically put their nodes in the correct paths.

### `lido_classification`

Generate the `objectClassificationWrap` containing the `classification` and `objectWorkType` nodes.

```
    lido_classification(
        object_work_type, # objectWorkType.term, as path.
        classification, # classification.term, as path.
        -object_work_type_id: objectWorkType.conceptID, # As path.
        -classification_id: classification.conceptID, # As path.
        -object_work_type_type: objectWorkType.type, # String.
        -object_work_type_source: objectWorkType.source, # String.
        -classification_type: classification.type, # String.
        -classification_source: classification_source, # String.
        -lang: objectClassificationWrap.*.lang # String.
    )
```

### `lido_inscription`

Generate a `inscriptions` block at `descriptiveMetadata.objectIdentificationWrap.inscriptionsWrap`. Provides the `inscriptionTranscription` and `descriptiveNoteValue` nodes.

```
    lido_inscription(
        -transcription: inscriptionTranscription, # As path.
        -descriptive_note: inscriptionDescription, # As path.
        -type: inscriptionTranscription.type, # String.
        -label: inscriptionTranscription.label & descriptiveNote.label, # String.
        -lang: inscriptionDescription.lang & inscriptionTranscription.lang # String.
    )
```

### `lido_objectmeasurements`

Create an `objectMeasurements` in `descriptiveMetadata.objectIdentificationWrap.objectMeasurementsWrap.objectMeasurementsSet`. Provides `extentMeasurements`, `measurementType`, `measurementUnit` and `measurementValue`. Repeatable.

```
    lido_objectmeasurements(
        extent, # String.
        type, # Path.
        unit, # Path.
        value # Path.
    )
```

### `lido_actor`

Create a `actorInRole` node. You must provide the path where it has to appear (e.g. `eventWrap.eventSet.event`), as it has multiple possible positions. Provides `actorID`, `nameActorSet`, `nationalityActor`, `vitalDatesActor`, `roleActor` and `attributionQualifierActor`.

```
    lido_actor(
        path, # Path where the node must be generated. Do not include actorInRole as part of the path.
        id, # actorID, as path.
        name, # nameActorSet, as path.
        -id_label: actorID.label, # String.
        -id_source: actorID.source, # String.
        -id_type: actorID.type, # String, required if id is set
        -nationality: nationalityActor, # As path.
        -birthdate: vitalDatesActor.earliestDate, # As path.
        -deathdate: vitalDatesActor.latestDate, # As path.
        -role: roleActor.term, # As path.
        -role_id: roleActor.conceptID, # As path.
        -role_id_type: roleActor.conceptID.type, # String.
        -role_id_source: roleActor.conceptID.source, # String.
        -qualifier: attributionQualifierActor # As path.
    )
```


# SEE ALSO

[Catmandu](https://metacpan.org/pod/Catmandu),
[Catmandu::Fix](https://metacpan.org/pod/Catmandu::Fix)

# AUTHOR

Pieter De Praetere, `<pieter at packed.be>`

# CONTRIBUTORS

- Pieter De Preatere, `<pieter at packed.be>`
- Matthias Vandermaesen, `<matthias at colada.be>`

# LICENSE AND COPYRIGHT

This program is free software; you can redistribute it and/or modify it
under the terms of either: the GNU General Public License as published
by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.
