/*
 *  hstmt.h
 *
 *  $Id: hstmt.h,v 1.7 1999/06/25 03:03:26 source Exp $
 *
 *  Query statement object management functions
 *
 *  The iODBC driver manager.
 *  
 *  Copyright (C) 1995 by Ke Jin <kejin@empress.com> 
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef	_HSTMT_H
#define	_HSTMT_H

#include <config.h>

#include <sql.h>
#include <sqlext.h>

typedef struct STMT
  {
    int type;			/* must be 1st field */

    struct STMT *next;

    HERR herr;
    HDBC hdbc;			/* back point to connection object */
    HSTMT dhstmt;		/* driver's stmt handle */

    int state;
    int cursor_state;
    int prep_state;
    int asyn_on;		/* async executing which odbc call */
    int need_on;		/* which call return SQL_NEED_DATA */
  }
STMT_t;

#define IS_VALID_HSTMT(x) \
	((x) != SQL_NULL_HSTMT && \
	 (x)->type == SQL_HANDLE_STMT && \
	 (x)->hdbc != SQL_NULL_HDBC)

enum
  {
    en_stmt_allocated = 0,
    en_stmt_prepared,
    en_stmt_executed,
    en_stmt_cursoropen,
    en_stmt_fetched,
    en_stmt_xfetched,
    en_stmt_needdata,		/* not call SQLParamData() yet */
    en_stmt_mustput,		/* not call SQLPutData() yet */
    en_stmt_canput		/* SQLPutData() called */
  };				/* for statement handle state */

enum
  {
    en_stmt_cursor_no = 0,
    en_stmt_cursor_named,
    en_stmt_cursor_opened,
    en_stmt_cursor_fetched,
    en_stmt_cursor_xfetched
  };				/* for statement cursor state */

extern SQLRETURN _iodbcdm_dropstmt ();
#endif
