package WARC::Volume;						# -*- CPerl -*-

use strict;
use warnings;

our @ISA = qw();

require WARC; *WARC::Volume::VERSION = \$WARC::VERSION;

require WARC::Record;

=head1 NAME

WARC::Volume - Web ARChive file access for Perl

=head1 SYNOPSIS

  use WARC::Volume;

  $volume = mount WARC::Volume ($filename);

  $filename = $volume->filename;

  $handle = $volume->open;

  $record = $volume->first_record;

  $record = $volume->record_at($offset);

  $record = $volume->search(url => $url, time => $when);

=head1 DESCRIPTION

C<WARC::Volume> ...

=head2 Methods

=over

=item $volume = mount WARC::Volume ($filename)

Construct a C<WARC::Volume> object.  The parameter is the name of an
existing WARC file.  An exception is raised if the first record does not
have a valid WARC header.

=cut

sub mount {
}

=item $volume-E<gt>filename

Return the filename for this volume.

=cut

sub filename {
}

=item $volume-E<gt>open

Return a readable and seekable file handle for this volume.  The returned
value may be a tied handle.  Do not assume that it is an C<IO::Handle>.

=cut

sub open {
}

=item $volume-E<gt>first_record

Construct and return a C<WARC::Record> object representing the first WARC
record in $volume.  This should be a "warcinfo" record, but it is not
required to be so.

=cut

sub first_record {
}

=item $volume-E<gt>record_at( $offset )

Construct and return a C<WARC::Record> object representing the WARC record
beginning at $offset within $volume.  An exception is raised if an
appropriate magic number is not found at $offset.

=cut

sub record_at {
}

=back

=cut

1;
__END__

=head1 AUTHOR

Jacob Bachmeyer, E<lt>jcb@cpan.orgE<gt>

=head1 SEE ALSO

L<WARC>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2019 by Jacob Bachmeyer

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
