package Daje::Workflow::Database::Model::WorkflowConnection;
use Mojo::Base -base, -signatures;
use v5.40;

# NAME
# ====
#
# Daje::Workflow::Database::Model::WorkflowConnection
#
#
# REQUIRES
# ========
#
# Mojo::Base>
#
#
# METHODS
#
#  load($self)
#
#  save();
#
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>

use Data::Dumper;

has 'db';

sub load($self, $data) {

    my $result = $self->db->select(
        'workflow_connections', undef,
        {
            connector      => $data->{connector},
            connector_fkey => $data->{connector_pkey},
        }
    );

    my $hash;
    $hash = $result->hash if $result->rows > 0;

    return $hash;
}

sub insert($self, $data) {

    my $workflow_connections_pkey = 0;
    try {
            delete %$data{workflow_connections_pkey};
            $workflow_connections_pkey= $self->db->insert(
                "workflow_connections",
                {
                    workflow_fkey  => $data->{workflow_fkey},
                    connector      => $data->{connector},
                    connector_fkey => $data->{connector_fkey},
                },
                {
                    returning => 'workflow_connections_pkey'
                }
            )->hash->{workflow_connections_pkey};
        } catch ($e) {
            my $test = $e;
            say $e->to_string;
            $e = $e;
        };

    return $workflow_connections_pkey;
}
1;





#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::Database::Model::WorkflowConnection




=head1 REQUIRES


Mojo::Base>


METHODS

 load($self)

 save();




=head1 METHODS

=head2 insert($self,

 insert($self,();

=head2 load($self,

 load($self,();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>


=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

