# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.1
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

package Math::GSL::PowInt;
use base qw(Exporter);
use base qw(DynaLoader);
package Math::GSL::PowIntc;
bootstrap Math::GSL::PowInt;
package Math::GSL::PowInt;
@EXPORT = qw();

# ---------- BASE METHODS -------------

package Math::GSL::PowInt;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Math::GSL::PowInt;

*gsl_error = *Math::GSL::PowIntc::gsl_error;
*gsl_stream_printf = *Math::GSL::PowIntc::gsl_stream_printf;
*gsl_strerror = *Math::GSL::PowIntc::gsl_strerror;
*gsl_set_error_handler = *Math::GSL::PowIntc::gsl_set_error_handler;
*gsl_set_error_handler_off = *Math::GSL::PowIntc::gsl_set_error_handler_off;
*gsl_set_stream_handler = *Math::GSL::PowIntc::gsl_set_stream_handler;
*gsl_set_stream = *Math::GSL::PowIntc::gsl_set_stream;
*gsl_pow_2 = *Math::GSL::PowIntc::gsl_pow_2;
*gsl_pow_3 = *Math::GSL::PowIntc::gsl_pow_3;
*gsl_pow_4 = *Math::GSL::PowIntc::gsl_pow_4;
*gsl_pow_5 = *Math::GSL::PowIntc::gsl_pow_5;
*gsl_pow_6 = *Math::GSL::PowIntc::gsl_pow_6;
*gsl_pow_7 = *Math::GSL::PowIntc::gsl_pow_7;
*gsl_pow_8 = *Math::GSL::PowIntc::gsl_pow_8;
*gsl_pow_9 = *Math::GSL::PowIntc::gsl_pow_9;
*gsl_pow_int = *Math::GSL::PowIntc::gsl_pow_int;
*gsl_pow_uint = *Math::GSL::PowIntc::gsl_pow_uint;

# ------- VARIABLE STUBS --------

package Math::GSL::PowInt;

*GSL_VERSION = *Math::GSL::PowIntc::GSL_VERSION;
*GSL_MAJOR_VERSION = *Math::GSL::PowIntc::GSL_MAJOR_VERSION;
*GSL_MINOR_VERSION = *Math::GSL::PowIntc::GSL_MINOR_VERSION;
*GSL_POSZERO = *Math::GSL::PowIntc::GSL_POSZERO;
*GSL_NEGZERO = *Math::GSL::PowIntc::GSL_NEGZERO;
*GSL_SUCCESS = *Math::GSL::PowIntc::GSL_SUCCESS;
*GSL_FAILURE = *Math::GSL::PowIntc::GSL_FAILURE;
*GSL_CONTINUE = *Math::GSL::PowIntc::GSL_CONTINUE;
*GSL_EDOM = *Math::GSL::PowIntc::GSL_EDOM;
*GSL_ERANGE = *Math::GSL::PowIntc::GSL_ERANGE;
*GSL_EFAULT = *Math::GSL::PowIntc::GSL_EFAULT;
*GSL_EINVAL = *Math::GSL::PowIntc::GSL_EINVAL;
*GSL_EFAILED = *Math::GSL::PowIntc::GSL_EFAILED;
*GSL_EFACTOR = *Math::GSL::PowIntc::GSL_EFACTOR;
*GSL_ESANITY = *Math::GSL::PowIntc::GSL_ESANITY;
*GSL_ENOMEM = *Math::GSL::PowIntc::GSL_ENOMEM;
*GSL_EBADFUNC = *Math::GSL::PowIntc::GSL_EBADFUNC;
*GSL_ERUNAWAY = *Math::GSL::PowIntc::GSL_ERUNAWAY;
*GSL_EMAXITER = *Math::GSL::PowIntc::GSL_EMAXITER;
*GSL_EZERODIV = *Math::GSL::PowIntc::GSL_EZERODIV;
*GSL_EBADTOL = *Math::GSL::PowIntc::GSL_EBADTOL;
*GSL_ETOL = *Math::GSL::PowIntc::GSL_ETOL;
*GSL_EUNDRFLW = *Math::GSL::PowIntc::GSL_EUNDRFLW;
*GSL_EOVRFLW = *Math::GSL::PowIntc::GSL_EOVRFLW;
*GSL_ELOSS = *Math::GSL::PowIntc::GSL_ELOSS;
*GSL_EROUND = *Math::GSL::PowIntc::GSL_EROUND;
*GSL_EBADLEN = *Math::GSL::PowIntc::GSL_EBADLEN;
*GSL_ENOTSQR = *Math::GSL::PowIntc::GSL_ENOTSQR;
*GSL_ESING = *Math::GSL::PowIntc::GSL_ESING;
*GSL_EDIVERGE = *Math::GSL::PowIntc::GSL_EDIVERGE;
*GSL_EUNSUP = *Math::GSL::PowIntc::GSL_EUNSUP;
*GSL_EUNIMPL = *Math::GSL::PowIntc::GSL_EUNIMPL;
*GSL_ECACHE = *Math::GSL::PowIntc::GSL_ECACHE;
*GSL_ETABLE = *Math::GSL::PowIntc::GSL_ETABLE;
*GSL_ENOPROG = *Math::GSL::PowIntc::GSL_ENOPROG;
*GSL_ENOPROGJ = *Math::GSL::PowIntc::GSL_ENOPROGJ;
*GSL_ETOLF = *Math::GSL::PowIntc::GSL_ETOLF;
*GSL_ETOLX = *Math::GSL::PowIntc::GSL_ETOLX;
*GSL_ETOLG = *Math::GSL::PowIntc::GSL_ETOLG;
*GSL_EOF = *Math::GSL::PowIntc::GSL_EOF;


our @EXPORT_OK = qw/gsl_pow_2 gsl_pow_2 gsl_pow_3
                    gsl_pow_4 gsl_pow_5 gsl_pow_6
                    gsl_pow_7 gsl_pow_8 gsl_pow_9 gsl_pow_int
                /;
our %EXPORT_TAGS = ( all =>  \@EXPORT_OK );

__END__

=encoding utf8

=head1 NAME

Math::GSL::PowInt - Integer Power functions

=head1 SYNOPSIS

    use Math::GSL::PowInt qw /gsl_pow_2 gsl_pow_4 gsl_pow_int/;
    print '2**4  = ' . gsl_pow_2(4) . "\n";
    print '4**7  = ' . gsl_pow_4(7) . "\n";
    print '17**5 = ' . gsl_pow_int(17,5) . "\n";

=head1 DESCRIPTION

This module implements the GSL Integer Power functions, which allow one to
quickly compute a given integer raised to any real number.  It contains
gsl_pow_2 to gsl_pow_9 and gsl_pow_int. If you need a power higher than 9, you
can use gsl_pow_int, which takes a base as the first argument and power being
raised to as the second argument.

You can also write

C<use Math::GSL::PowInt qw/:all/;>

to use all available functions of the module.

=head1 PURPOSE

This module doesn't provide much performance improvement over the Perl builtin
'**' operator, but is included for completeness.

=head1 BENCHMARKS

DANAJ has included some benchmarks in a bug report L<https://rt.cpan.org/Ticket/Display.html?id=96440>

=head1 AUTHORS

Jonathan "Duke" Leto <jonathan@leto.net> and Thierry Moisan <thierry.moisan@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008-2020 Jonathan "Duke" Leto and Thierry Moisan

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut
1;
