package TypeTest::Objects;

use Elastic::Doc;
use MooseX::Types -declare => ['NotDefined'];
use MooseX::Types::Moose qw(:all);

#===================================
has 'object_attr' => (
#===================================
    is  => 'ro',
    isa => 'Object',
);

#===================================
has 'objectx_attr' => (
#===================================
    is  => 'ro',
    isa => Object,
);

#===================================
has 'doc_attr' => (
#===================================
    is  => 'ro',
    isa => 'Foo::User',
);

#===================================
has 'doc_none_attr' => (
#===================================
    is            => 'ro',
    isa           => 'Foo::User',
    include_attrs => [],
);

#===================================
has 'doc_name_attr' => (
#===================================
    is            => 'ro',
    isa           => 'Foo::User',
    include_attrs => ['name'],
);

#===================================
has 'doc_exname_attr' => (
#===================================
    is            => 'ro',
    isa           => 'Foo::User',
    exclude_attrs => ['name'],
);

#===================================
has 'moose_attr' => (
#===================================
    is  => 'ro',
    isa => 'Moose::One',
);

#===================================
has 'moose_none_attr' => (
#===================================
    is            => 'ro',
    isa           => 'Moose::One',
    include_attrs => [],
);

#===================================
has 'moose_name_attr' => (
#===================================
    is            => 'ro',
    isa           => 'Moose::One',
    include_attrs => ['name'],
);

#===================================
has 'moose_exname_attr' => (
#===================================
    is            => 'ro',
    isa           => 'Moose::One',
    exclude_attrs => ['name'],
);

#===================================
has 'non_moose_attr' => (
#===================================
    is  => 'ro',
    isa => 'Non::Moose',
);

#===================================
has 'not_defined_attr' => (
#===================================
    is  => 'ro',
    isa => NotDefined,
);

#===================================
has 'custom_attr' => (
#===================================
    is       => 'ro',
    mapping  => { type => 'string' },
    deflator => sub { $_[0] * 2 },
    inflator => sub { $_[0] / 2 }
);

#===================================
has 'bad_mapping_attr' => (
#===================================
    is  => 'ro',
    isa => 'BadMapping',
);

#===================================
has 'custom_class_attr' => (
#===================================
    is  => 'ro',
    isa => 'CustomClass',
);

#===================================
has 'no_tc_attr' => (
#===================================
    is => 'ro',
);

#===================================

package Moose::One;
use Moose;

#===================================
has 'name' => (
#===================================
    is  => 'ro',
    isa => 'Str',
);

#===================================
has 'two' => (
#===================================
    is  => 'ro',
    isa => 'Moose::Two'
);

package Moose::Two;
use Moose;

#===================================
has 'foo' => (
#===================================
    is  => 'ro',
    isa => 'Str',
);

package Non::Moose;

#===================================
sub foo { }
#===================================

no Elastic::Doc;

1;

