#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Math::Prime::Util qw/ is_happy vecall addint /;

my $extra = defined $ENV{EXTENDED_TESTING} && $ENV{EXTENDED_TESTING};

my @a007770 = (1,7,10,13,19,23,28,31,32,44,49,68,70,79,82,86,91,94,97,100,103,109,129,130,133,139,167,176,188,190,192,193,203,208,219,226,230,236,239,262,263,280,291,293,301,302,310,313,319,320,326,329,331,338,356,362,365,367,368,376,379,383,386,391,392,397,404,409,440,446,464,469,478,487,490,496,536,556,563,565,566,608,617,622,623,632,635,637,638,644,649,653,655,656,665,671,673,680,683,694,700,709);
my @a090425 = (1,6,2,3,5,4,4,3,4,5,5,3,6,4,4,3,5,5,4,2,3,5,4,3,6,6,4,4,5,5,4,6,4,4,4,6,4,6,6,6,6,4,4,6,3,4,3,6,6,4,6,6,6,5,7,6,7,6,6,6,7,5,6,6,6,7,5,5,5,4,4,7,5,5,5,7,7,4,7,4,5,3,4,6,6,6,7,6,6,4,7,7,4,5,5,4,6,3,6,7,6,4);

my @a239320 = (1,3,9,13,17,23,25,27,31,35,37,39,47,51,53,59,61,65,69,71,73,75,77,79,81,85,89,91,93,101,105,107,109,111,117,137,141,143,153,155,159,161,167,169,173,177,179,181,183,185,187,191,195,197,207,209,213);

my @a240849 = (1,5,7,11,19,23,25,27,33,35,41,43,49,51,55,79,81,83,91,93,95,99,103,109,115,119,121,123,125,127,133,135,141,143,149,153,157,159,161,165,169,171,173,175,181,189,193,197,201,203,205,209,213,215,217,219,221,223,229,231,233,237,241,243,245,249);

my @base16 = (1,2,4,6,8,11,16,17,20,24,27,32,34,36,38,39,40,53,59,64,65,66,68,71,74,83,87,88,89,96,98,105,106,110,114,116,117,119,121,122,127,128,129,130,133,136,138,141,142,143,149);

my @base36 = (1,6,36,216,467);

my @k3 = (1,10,100,112,121,211,778,787,877,1000,1012,1021,1102,1120,1189,1198,1201,1210,1234,1243,1324,1342,1423,1432,1579,1597,1759,1795,1819,1891,1918,1957,1975,1981,2011,2101,2110,2134,2143,2314,2341,2413,2431,2779,2797,2977);

my %ex = (
  10234456789 => 4,   1234456789 => 4,
  "1034567892987654301" => 6,   "13456789298765431" => 6,
  7777777777 => 6, 778688 => 7, 11025 => 4,
  "99194853094755497" => 7,
  69378 => 7,
);

plan tests => 4 + 6 + 1 + 5;

is_deeply( [grep { is_happy($_) } 0..715],
           \@a007770,
           "is_happy(0..715) boolean" );

is_deeply( [map { is_happy($_) } @a007770],
           \@a090425,
           "is_happy(0..709) heights" );

is(is_happy(78999), 8, "78999 has a happy height of 8");
is(is_happy("3788" . ("9"x973)), 9, "3788(9)_973 has a happy height of 9");

{
  my @happy_consec = (0,0,31,1880,7839,44488,"7899999999999959999999996","7899999999999959999999996");
  for my $k (2..7) {
    my $n = $happy_consec[$k];
    my $pass = vecall { is_happy(addint($n,$_)) } 0..$k-1;
    ok($pass, "$n is the start of $k consecutive happy numbers");
  }
}

{
  my(@N,@H);
  for my $n (keys %ex) {
    push @N, $n;
    push @H, $ex{$n};
  }
  is_deeply([map { is_happy($_) } @N], \@H, "some selected examples");
}

is_deeply( [grep { is_happy($_,3,2) } 0..214],
           \@a239320,
           "is_happy(0..214,3,2) boolean (base 3)" );

is_deeply( [grep { is_happy($_,5,2) } 0..250],
           \@a240849,
           "is_happy(0..250,5,2) boolean (base 5)" );

is_deeply( [grep { is_happy($_,16,2) } 0..149],
           \@base16,
           "is_happy(0..149,16,2) boolean (base 16)" );

is_deeply( [grep { is_happy($_,36,2) } 0..500],
           \@base36,
           "is_happy(0..500,36,2) boolean (base 36)" );

is_deeply( [grep { is_happy($_,10,3) } 0..3000],
           \@k3,
           "is_happy(0..3000,10,3) boolean (sum of cubes of digits)" );
