#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Math::Prime::Util qw/chinese chinese2/;

#my $extra = defined $ENV{EXTENDED_TESTING} && $ENV{EXTENDED_TESTING};
#my $use64 = Math::Prime::Util::prime_get_config->{'maxbits'} > 32;
#my $usexs = Math::Prime::Util::prime_get_config->{'xs'};
#my $usegmp= Math::Prime::Util::prime_get_config->{'gmp'};
#$use64 = 0 if $use64 && 18446744073709550592 == ~0;

my @crts = (
  [ [], 0, 0 ],
  [ [[4,5]], 4, 5 ],
  [ [[77,11]], 0, 11 ],
  [ [[0,5],[0,6]], 0, 30 ],
  [ [[14,5],[0,6]], 24, 30 ],
  [ [[10,11],[4,22],[9,19]], undef, undef ],
  [ [[77,13],[79,17]], 181, 221 ],
  [ [[2,3],[3,5],[2,7]], 23, 105 ],
  [ [[10,11],[4,12],[12,13]], 1000, 1716 ],
  [ [[42,127],[24,128]], 2328, 16256 ],             # Some tests from Mod::Int
  [ [[32,126],[23,129]], 410, 5418 ],
  [ [[2328,16256],[410,5418]], 28450328, 44037504 ],
  [ [[1,10],[11,100]], 11, 100 ],
  [ [[11,100],[22,100]], undef, undef ],
  [ [[3,5],[2,0]], undef, undef ],       # three tests that we handle zeros.
  [ [[3,0],[2,3]], undef, undef ],
  [ [[3,5],[3,0],[2,3]], undef, undef ],
  [ [[5,0],[15,1]], undef, undef ],      # two more test for zeros
  [ [[15,1],[5,0]], undef, undef ],
  # Tests to make IV_MAX < lcm < UV_MAX
  [ [[2,181], [3,193], [5,227], [30,383]], 2205672518, 3037109953],
  # Negative modulos
  [ [[14,-5], [ 17, -6]], 29, 30],
  [ [[14, 5], [ 17, -6]], 29, 30],
  [ [[-4,17], [-17, 19]], 268, 323],
  [ [[-4,17], [-17, 19]], 268, 323],
  [ [[-4,17], [ 17,-19]], 302, 323],
);

my @crt_big = (
  [ [[14,44381], [87,48473], [19,59467], [74,118751]],
    "6441035217555187414", "15191836855823857721"],
  [ [[1753051086,3243410059],[2609156951,2439462460]],
    "6553408220202087311", "7912177081316885140"],
  [ [ ["6325451203932218304","2750166238021308"],
      ["5611464489438299732","94116455416164094"] ],
    "1433171050835863115088946517796","129417949063886082109332998257476" ],
  [ [ ["1762568892212871168","8554171181844660224"],
      ["2462425671659520000","2016911328009584640"] ],
    "188079320578009823963731127992320","263259960302667721456496781557760" ],
  [ [ ["856686401696104448","11943471150311931904"],
      ["6316031051955372032","13290002569363587072"] ],
    "943247297188055114646647659888640","1211004350851176848301478947323904" ],
  [ [[-3105579549,3743000622],[-1097075646,1219365911]],
    "2754322117681955433", "4564087363318596642"],
  [ [ ["-925543788386357567","243569243147991"],
      ["-1256802905822510829","28763455974459440"] ],
    "837055903505897549759994093811", "7005893202019645748120146985040" ],
  [ [ ["-2155972909982577461","8509855219791386062"],
      ["-5396280069505638574","6935743629860450393"] ],
    "12941173114744545542549046204020289525","59022174131702808856838498513062622366" ],
);

plan tests => 2 + 2;

###### chinese
is_deeply(
  [ map { chinese(@{$_->[0]}) } @crts ],
  [ map { $_->[1] } @crts ],
  "chinese()"
);
###### chinese2
is_deeply(
  [ map { [chinese2(@{$_->[0]})] } @crts ],
  [ map { [$_->[1],$_->[2]] } @crts ],
  "chinese2()"
);

# big results.
# Some combinations of Test::More and Math::GMPz don't get along
# Also Math::GMP is missing some overloads.
is_deeply(
  [ map { "" . chinese(@{$_->[0]}) } @crt_big ],
  [ map { $_->[1] } @crt_big ],
  "chinese() big result"
);
###### chinese2
is_deeply(
  [ map { [map { "$_" } chinese2(@{$_->[0]})] } @crt_big ],
  [ map { [$_->[1],$_->[2]] } @crt_big ],
  "chinese2() big result"
);
