#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Math::Prime::Util qw/mulint/;


my @vals = (
  [qw/13282407956253574712 14991082624209354397 199117675120653046511338473800925208664/],
  [qw/65536 65536 4294967296/],
  [qw/28778071877862015 641 18446744073709551615/],
  [qw/4294967295 4294967295 18446744065119617025/],
  [qw/4294967295 4294967296 18446744069414584320/],
  [qw/4294967296 4294967296 18446744073709551616/],

  [qw/9223372036854775807  1  9223372036854775807/],
  [qw/9223372036854775808  1  9223372036854775808/],
  [qw/9223372036854775807 -1 -9223372036854775807/],
  [qw/9223372036854775808 -1 -9223372036854775808/],
  [qw/-9223372036854775807  1 -9223372036854775807/],
  [qw/-9223372036854775808  1 -9223372036854775808/],
  [qw/-9223372036854775807 -1  9223372036854775807/],
  [qw/-9223372036854775808 -1  9223372036854775808/],

  [qw/18446744073709551615 1 18446744073709551615/],
  [qw/18446744073709551615 -1 -18446744073709551615/],
  [qw/18446744073709551616 1 18446744073709551616/],
  [qw/18446744073709551616 -1 -18446744073709551616/],

  [qw/18446744073709551615 2 36893488147419103230/],
);

plan tests => 2;

###### mulint
{ my(@got,@exp);
  for my $a (-3 .. 3) {
    for my $b (-3 .. 3) {
      push @got, mulint($a,$b);
      push @exp, $a == 0 || $b == 0 ? 0 : $a*$b;  # Perl 5.6: -1*0 = -0
    }
  }
  is_deeply( \@got, \@exp, "mulint( -3 .. 3, -3 .. 3)" );
}
is_deeply( [map{"$_"}map { mulint($_->[0],$_->[1]) } @vals],
           [map { $_->[2] } @vals],
           "mulint a*b=c" );
