use 5.14.0;

package Map::Metro::Plugin::Map::Amsterdam;

our $VERSION = '0.1101'; # VERSION

use Moose;
with 'Map::Metro::Plugin::Map';

has '+mapfile' => (
    default => 'map-amsterdam.metro',
);
sub map_version {
    return $VERSION;
}
sub map_package {
    return __PACKAGE__;
}

1;

__END__

=pod

=encoding utf-8

=head1 NAME

Map::Metro::Plugin::Map::Amsterdam

=head1 VERSION

Version 0.1101, released 2015-01-25.

=head1 SYNOPSIS

    use Map::Metro;
    my $graph = Map::Metro->new('Amsterdam')->parse;

Or:

    $ map-metro.pl route Amsterdam Isolatorweg Gein

=head1 DESCRIPTION

See L<Map::Metro> for usage information.

=head1 NAME

Map::Metro::Plugin::Map::Amsterdam - Map::Metro map for Amsterdam

=head1 Status

This map L<contains|Map::Metro::Plugin::Map::Amsterdam::Lines>:

=over 4

=item *

Lines 50, 51, 53 and 54 [L<wikipedia|https://en.wikipedia.org/wiki/Amsterdam_metro>]

=back

=for HTML <p><a href="https://raw.githubusercontent.com/Csson/p5-Map-Metro-Amsterdam/master/static/images/amsterdam.png"><img src="https://raw.githubusercontent.com/Csson/p5-Map-Metro-Amsterdam/master/static/images/amsterdam.png" style="max-width: 600px" /></a></p>

=head1 SOURCE

Source repository is at L<https://github.com/Csson/p5-Map-Metro-Amsterdam>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Map-Metro-Plugin-Map-Amsterdam>.

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
