/*
 * Decompiled with CFR 0.152.
 */
import java.io.OutputStreamWriter;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ApplyXPathJAXP {
    public static void main(String[] args) {
        QName returnType = null;
        if (args.length != 3) {
            System.err.println("Usage: java ApplyXPathAPI xml_file xpath_expression type");
        }
        InputSource xml = new InputSource(args[0]);
        String expr = args[1];
        if (args[2].equals("num")) {
            returnType = XPathConstants.NUMBER;
        } else if (args[2].equals("bool")) {
            returnType = XPathConstants.BOOLEAN;
        } else if (args[2].equals("str")) {
            returnType = XPathConstants.STRING;
        } else if (args[2].equals("node")) {
            returnType = XPathConstants.NODE;
        } else if (args[2].equals("nodeset")) {
            returnType = XPathConstants.NODESET;
        } else {
            System.err.println("Invalid return type: " + args[2]);
        }
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        Object result = null;
        try {
            XPathExpression xpathExpr = xpath.compile(expr);
            result = xpathExpr.evaluate(xml, returnType);
            ApplyXPathJAXP.printResult(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void printResult(Object result) throws Exception {
        if (result instanceof Double) {
            System.out.println("Result type: double");
            System.out.println("Value: " + result);
        } else if (result instanceof Boolean) {
            System.out.println("Result type: boolean");
            System.out.println("Value: " + (Boolean)result);
        } else if (result instanceof String) {
            System.out.println("Result type: String");
            System.out.println("Value: " + result);
        } else if (result instanceof Node) {
            Node node = (Node)result;
            System.out.println("Result type: Node");
            System.out.println("<output>");
            ApplyXPathJAXP.printNode(node);
            System.out.println("</output>");
        } else if (result instanceof NodeList) {
            NodeList nodelist = (NodeList)result;
            System.out.println("Result type: NodeList");
            System.out.println("<output>");
            ApplyXPathJAXP.printNodeList(nodelist);
            System.out.println("</output>");
        }
    }

    static boolean isTextNode(Node n) {
        if (n == null) {
            return false;
        }
        short nodeType = n.getNodeType();
        return nodeType == 4 || nodeType == 3;
    }

    static void printNode(Node node) throws Exception {
        if (ApplyXPathJAXP.isTextNode(node)) {
            System.out.println(node.getNodeValue());
        } else {
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.transform(new DOMSource(node), new StreamResult(new OutputStreamWriter(System.out)));
        }
    }

    static void printNodeList(NodeList nodelist) throws Exception {
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node n = nodelist.item(i);
            if (ApplyXPathJAXP.isTextNode(n)) {
                StringBuffer sb = new StringBuffer(n.getNodeValue());
                Node nn = n.getNextSibling();
                while (ApplyXPathJAXP.isTextNode(nn)) {
                    sb.append(nn.getNodeValue());
                    nn = nn.getNextSibling();
                }
                System.out.print(sb);
            } else {
                serializer.transform(new DOMSource(n), new StreamResult(new OutputStreamWriter(System.out)));
            }
            System.out.println();
        }
    }
}

