/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.axiom.soap.impl.common.builder;

import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.XmlHandlerWrapper;
import org.apache.axiom.soap.SOAPProcessingException;

final class SOAPFilterHandler extends XmlHandlerWrapper {
    SOAPFilterHandler(XmlHandler parent) {
        super(parent);
    }

    @Override
    public void processDocumentTypeDeclaration(
            String rootName, String publicId, String systemId, String internalSubset)
            throws StreamException {
        throw new SOAPProcessingException(
                "SOAP message MUST NOT contain a Document Type Declaration(DTD)");
    }

    @Override
    public void startProcessingInstruction(String target) throws StreamException {
        throw new SOAPProcessingException(
                "SOAP message MUST NOT contain Processing Instructions(PI)");
    }

    @Override
    public void processEntityReference(String name, String replacementText) throws StreamException {
        throw new SOAPProcessingException(
                "A SOAP message cannot contain entity references because it must not have a DTD");
    }
}
