
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  First use setAttribute to create a new attribute on the third strong element.  Invoke setIdAttribute
 *  on the new  attribute. Verify by calling isID on the new attribute and getElementById on document.
 *  Invoke setIdAttribute again to reset. Calling isID should return false.
* @author IBM
* @author Jenny Hsu
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-ElSetIdAttr">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-ElSetIdAttr</a>
*/
public final class elementsetidattribute04 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public elementsetidattribute04(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList elemList;
      Element nameElem;
      NamedNodeMap attributesMap;
      Attr attr;
      boolean id = false;
      Element elem;
      String elemName;
      doc = (Document) load("hc_staff", true);
      elemList = doc.getElementsByTagName("strong");
      nameElem = (Element) elemList.item(2);
      nameElem.setAttribute("hasMiddleName", "Antoine");
      nameElem.setIdAttribute("hasMiddleName", true);
      attributesMap = nameElem.getAttributes();
      attr = (Attr) attributesMap.getNamedItem("hasMiddleName");
      id = attr.isId();
      assertTrue("elementsetidattributeIsIdTrue03", id);
      elem = doc.getElementById("Antoine");
      elemName = elem.getTagName();
      assertEquals("elementsetidattributeGetElementById03", "strong", elemName);
      nameElem.setIdAttribute("hasMiddleName", false);
      id = attr.isId();
      assertFalse("elementsetidattributeIsIdFalse03", id);
}
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/elementsetidattribute04";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(elementsetidattribute04.class, args);
   }
}

