/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.sax;

import java.io.IOException;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.sax.output.ContentHandlerXmlHandler;
import org.apache.axiom.om.impl.intf.AxiomContainer;
import org.apache.axiom.om.impl.stream.NamespaceContextPreservationFilterHandler;
import org.apache.axiom.util.sax.AbstractXMLReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLReaderImpl
extends AbstractXMLReader {
    private final AxiomContainer root;
    private final boolean cache;

    public XMLReaderImpl(AxiomContainer root, boolean cache) {
        this.root = root;
        this.cache = cache;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        this.parse();
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse();
    }

    private void parse() throws SAXException {
        XmlHandler handler = new ContentHandlerXmlHandler(this.contentHandler, this.lexicalHandler);
        CoreElement contextElement = this.root.getContextElement();
        if (contextElement != null) {
            handler = new NamespaceContextPreservationFilterHandler(handler, contextElement);
        }
        try {
            this.root.internalSerialize(handler, this.cache);
        }
        catch (CoreModelException ex) {
            throw new SAXException(ex);
        }
        catch (StreamException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            if (cause instanceof Exception) {
                throw new SAXException((Exception)cause);
            }
            throw new SAXException(ex);
        }
    }
}

