
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  Using compareDocumentPosition check if the document position of an Entity node compared to another
 *  Entity node following it in DocumentType is implementation specific.
* @author IBM
* @author Jenny Hsu
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Node3-compareDocumentPosition">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Node3-compareDocumentPosition</a>
*/
public final class nodecomparedocumentposition23 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public nodecomparedocumentposition23(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      DocumentType docType;
      NamedNodeMap entitiesMap;
      Entity entity;
      Entity entity2;
      int position1;
      int position2;
      int position3;
      doc = (Document) load("hc_staff", false);
      docType = doc.getDoctype();
      entitiesMap = docType.getEntities();
      entity = (Entity) entitiesMap.getNamedItem("alpha");
      entity2 = (Entity) entitiesMap.getNamedItem("delta");
      position1 = (int) entity.compareDocumentPosition(entity2);
      assertEquals("isImplSpecificDisconnected1", 32 & 57, position1 & 57);
      position2 = (int) entity2.compareDocumentPosition(entity);
      assertNotEquals("notBothPreceding", position1 & 2, position2 & 2);
assertNotEquals("notBothFollowing", position1 & 4, position2 & 4);
assertEquals("isImplSpecificDisconnected2", 32 & 57, position2 & 57);
      position3 = (int) entity.compareDocumentPosition(entity2);
      assertEquals("isConsistent", position1, position3);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/nodecomparedocumentposition23";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(nodecomparedocumentposition23.class, args);
   }
}

