
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  The adoptNode method changes the ownerDocument of a node, its children, as well as the 
 *  attached attribute nodes if there are any. If the node has a parent it is first removed 
 *  from its parent child list. 
 *  
 *  Invoke the adoptNode method on this Document with the source node being an existing attribute
 *         that is a part of this Document.   Verify that the returned adopted node's nodeName, nodeValue
 *         and nodeType are as expected and that the ownerElement attribute of the returned attribute node 
 *         was set to null.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-adoptNode">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-adoptNode</a>
*/
public final class documentadoptnode21 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public documentadoptnode21(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Element attrOwnerElem;
      Element element;
      Attr attr;
      NodeList childList;
      Node adoptedTitle;
      Node attrsParent;
      String nodeName;
      int nodeType;
      String nodeValue;
      doc = (Document) load("hc_staff", false);
      childList = doc.getElementsByTagName("acronym");
      element = (Element) childList.item(0);
      attr = element.getAttributeNode("title");
      adoptedTitle = doc.adoptNode(attr);
      nodeName = adoptedTitle.getNodeName();
      nodeValue = adoptedTitle.getNodeValue();
      nodeType = (int) adoptedTitle.getNodeType();
      attrOwnerElem = ((Attr) /*Node */adoptedTitle).getOwnerElement();
      assertEquals("documentadoptnode21_nodeName", "title", nodeName);
      assertEquals("documentadoptnode21_nodeType", 2, nodeType);
      assertEquals("documentadoptnode21_nodeValue", "Yes", nodeValue);
      assertNull("documentadoptnode21_ownerDoc", attrOwnerElem);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/documentadoptnode21";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(documentadoptnode21.class, args);
   }
}

