/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.axiom.ts.om.namespace;

import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.ts.AxiomTestCase;

/**
 * Tests the behavior of {@link Object#equals(Object)} for {@link OMNamespace} instances with same
 * namespace URI and prefix.
 */
public class TestObjectEquals extends AxiomTestCase {
    public TestObjectEquals(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    @Override
    protected void runTest() throws Throwable {
        OMFactory factory = metaFactory.getOMFactory();
        // The implementation must not assume that namespace URI or prefixes are interned.
        // Therefore we use new String(String).
        OMNamespace ns1 = factory.createOMNamespace(new String("urn:ns"), new String("ns"));
        OMNamespace ns2 = factory.createOMNamespace(new String("urn:ns"), new String("ns"));
        assertTrue(ns1.equals(ns2));
    }
}
