
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  Invoke the adoptNode method on this document using a new imported Element and a new attribute created in 
 *  a new Document as the source.  Verify if the node has been adopted correctly by checking the 
 *  nodeName of the adopted Element and by checking if the attribute was adopted.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-adoptNode">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-adoptNode</a>
*/
public final class documentadoptnode27 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public documentadoptnode27(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Element docElem;
      Element newElem;
      Element newImpElem;
      Document newDoc;
      DOMImplementation domImpl;
      Node adoptedNode;
      String adoptedName;
      String adoptedNS;
      Node appendedChild;
      DocumentType nullDocType = null;

      String rootNS;
      String rootTagname;
      doc = (Document) load("hc_staff", true);
      docElem = doc.getDocumentElement();
      rootNS = docElem.getNamespaceURI();
      rootTagname = docElem.getTagName();
      domImpl = doc.getImplementation();
      newDoc = domImpl.createDocument(rootNS, rootTagname, nullDocType);
      newElem = newDoc.createElementNS("http://www.w3.org/1999/xhtml", "xhtml:head");
      newElem.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", "en-US");
      docElem = newDoc.getDocumentElement();
      appendedChild = docElem.appendChild(newElem);
      newImpElem = (Element) doc.importNode(newElem, true);
      adoptedNode = doc.adoptNode(newImpElem);
      
      if ((adoptedNode != null)) {
          adoptedName = adoptedNode.getNodeName();
      adoptedNS = adoptedNode.getNamespaceURI();
      assertEquals("documentadoptnode27_1", "xhtml:head", adoptedName);
      assertEquals("documentadoptnode27_2", "http://www.w3.org/1999/xhtml", adoptedNS);
      }
    }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/documentadoptnode27";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(documentadoptnode27.class, args);
   }
}

