/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.value;

import java.util.Map;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.ValueMap;

public final class AttributeMap
extends ValueMap {
    private static final long serialVersionUID = 1L;

    public AttributeMap() {
    }

    public AttributeMap(Map<String, Object> map) {
        super((Map<? extends String, ?>)map);
    }

    public boolean putAttribute(String key, boolean value) {
        Object previous = this.get(key);
        if (value) {
            this.put(key, (Object)key);
        } else {
            this.remove(key);
        }
        return key.equals(previous);
    }

    public String putAttribute(String key, CharSequence value) {
        if (Strings.isEmpty(value)) {
            return (String)this.remove(key);
        }
        return (String)this.put(key, (Object)value);
    }

    @Override
    public String toString() {
        return this.toCharSequence().toString();
    }

    public CharSequence toCharSequence() {
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        for (String key : this.keySet()) {
            if (key == null) continue;
            buffer.append(' ');
            buffer.append(Strings.escapeMarkup(key));
            CharSequence value = this.getCharSequence(key);
            if (value == null) continue;
            buffer.append("=\"");
            buffer.append(Strings.escapeMarkup(value));
            buffer.append('\"');
        }
        return buffer;
    }
}

