/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.PartWriterCallback;

public class FileSystemResource
extends AbstractResource {
    private static final long serialVersionUID = 1L;
    private LoadableDetachableModel<Path> path;

    public FileSystemResource(Path path) {
        this.path = new PathModel(path);
    }

    public FileSystemResource() {
        this(null);
    }

    @Override
    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        return this.createResourceResponse(attributes, this.getPath());
    }

    @Override
    public void respond(IResource.Attributes attributes) {
        try {
            super.respond(attributes);
        }
        finally {
            if (this.path != null) {
                this.path.detach();
            }
        }
    }

    protected AbstractResource.ResourceResponse createResourceResponse(IResource.Attributes attributes, Path path) {
        try {
            if (path == null) {
                throw new WicketRuntimeException("Please override #newResourceResponse() and provide a path if using a constructor which doesn't take one as argument.");
            }
            this.path = new PathModel(path);
            long size = this.getSize();
            AbstractResource.ResourceResponse resourceResponse = new AbstractResource.ResourceResponse();
            resourceResponse.setContentType(this.getMimeType());
            resourceResponse.setAcceptRange(AbstractResource.ContentRangeType.BYTES);
            resourceResponse.setContentLength(size);
            if (path.getFileName() != null) {
                resourceResponse.setFileName(path.getFileName().toString());
            }
            RequestCycle cycle = RequestCycle.get();
            Long startbyte = (Long)cycle.getMetaData(CONTENT_RANGE_STARTBYTE);
            Long endbyte = (Long)cycle.getMetaData(CONTENT_RANGE_ENDBYTE);
            resourceResponse.setWriteCallback(new PartWriterCallback(this.getInputStream(), size, startbyte, endbyte).setClose(true));
            return resourceResponse;
        }
        catch (IOException e) {
            throw new WicketRuntimeException("An error occurred while processing the media resource response", e);
        }
    }

    protected long getSize() throws IOException {
        return Files.readAttributes(this.getPath(), BasicFileAttributes.class, new LinkOption[0]).size();
    }

    protected String getMimeType() throws IOException {
        Path _path = this.getPath();
        String mimeType = null;
        if (Application.exists()) {
            mimeType = Application.get().getMimeType(_path.getFileName().toString());
        }
        if (mimeType == null) {
            mimeType = Files.probeContentType(_path);
        }
        return mimeType;
    }

    protected InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.getPath(), new OpenOption[0]);
    }

    private Path getPath() {
        return this.path.getObject();
    }

    private static class PathModel
    extends LoadableDetachableModel<Path> {
        private static final long serialVersionUID = 1L;
        private final String pathAsString;

        public PathModel(Path path) {
            super(path);
            this.pathAsString = path == null ? null : path.toString();
        }

        @Override
        protected Path load() {
            return this.pathAsString == null ? null : Paths.get(this.pathAsString, new String[0]);
        }
    }
}

