/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.WeakHashMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.fit.internal.ClassLoaderUtils;
import org.apache.uima.fit.internal.MetaDataType;
import org.apache.uima.fit.internal.MetaDataUtil;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypePriorityList;
import org.apache.uima.resource.metadata.impl.TypePriorities_impl;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypePrioritiesFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TypePrioritiesFactory.class);
    private static final Object SCAN_LOCK = new Object();
    private static final Object CREATE_LOCK = new Object();
    private static WeakHashMap<ClassLoader, String[]> typePrioritesLocationsByClassloader = new WeakHashMap();
    private static WeakHashMap<ClassLoader, TypePriorities> typePrioritiesByClassloader = new WeakHashMap();

    private TypePrioritiesFactory() {
    }

    @SafeVarargs
    public static TypePriorities createTypePriorities(Class<? extends TOP> ... prioritizedTypes) {
        String[] typeNames = new String[prioritizedTypes.length];
        for (int i = 0; i < prioritizedTypes.length; ++i) {
            if (!TOP.class.isAssignableFrom(prioritizedTypes[i])) {
                throw new IllegalArgumentException("[" + prioritizedTypes[i] + "] is not a JCas type");
            }
            String typeName = prioritizedTypes[i].getName();
            if (typeName.startsWith("org.apache.uima.jcas.")) {
                typeName = "uima." + typeName.substring("org.apache.uima.jcas.".length());
            }
            typeNames[i] = typeName;
        }
        return TypePrioritiesFactory.createTypePriorities(typeNames);
    }

    public static TypePriorities createTypePriorities(String ... prioritizedTypeNames) {
        TypePriorities_impl typePriorities = new TypePriorities_impl();
        TypePriorityList typePriorityList = typePriorities.addPriorityList();
        for (String typeName : prioritizedTypeNames) {
            typePriorityList.addType(typeName);
        }
        return typePriorities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypePriorities createTypePriorities() throws ResourceInitializationException {
        ClassLoader cl = ClassLoaderUtils.findClassloader();
        TypePriorities aggTypePriorities = typePrioritiesByClassloader.get(cl);
        if (aggTypePriorities == null) {
            Object object = CREATE_LOCK;
            synchronized (object) {
                ArrayList<TypePriorities> typePrioritiesList = new ArrayList<TypePriorities>();
                for (String location : TypePrioritiesFactory.scanTypePrioritiesDescriptors()) {
                    try {
                        XMLInputSource xmlInput = new XMLInputSource(location);
                        TypePriorities typePriorities = UIMAFramework.getXMLParser().parseTypePriorities(xmlInput);
                        typePriorities.resolveImports();
                        typePrioritiesList.add(typePriorities);
                        LOG.debug("Detected type priorities at [{}]", (Object)location);
                    }
                    catch (IOException e) {
                        throw new ResourceInitializationException((Throwable)e);
                    }
                    catch (InvalidXMLException e) {
                        LOG.warn("[{}] is not a type priorities descriptor file. Ignoring.", (Object)location, (Object)e);
                    }
                }
                ResourceManager resMgr = ResourceManagerFactory.newResourceManager();
                aggTypePriorities = CasCreationUtils.mergeTypePriorities(typePrioritiesList, (ResourceManager)resMgr);
                typePrioritiesByClassloader.put(cl, aggTypePriorities);
            }
        }
        return (TypePriorities)aggTypePriorities.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] scanTypePrioritiesDescriptors() throws ResourceInitializationException {
        Object object = SCAN_LOCK;
        synchronized (object) {
            ClassLoader cl = ClassLoaderUtils.findClassloader();
            String[] typePrioritesLocations = typePrioritesLocationsByClassloader.get(cl);
            if (typePrioritesLocations == null) {
                typePrioritesLocations = MetaDataUtil.scanDescriptors(MetaDataType.TYPE_PRIORITIES);
                typePrioritesLocationsByClassloader.put(cl, typePrioritesLocations);
            }
            return typePrioritesLocations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceTypePrioritiesDescriptorsScan() {
        Object object = SCAN_LOCK;
        synchronized (object) {
            typePrioritesLocationsByClassloader.clear();
            typePrioritiesByClassloader.clear();
        }
    }
}

