/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.torque.Database;
import org.apache.torque.TorqueException;
import org.apache.torque.TorqueRuntimeException;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.adapter.AdapterFactory;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.dsfactory.DataSourceFactory;
import org.apache.torque.manager.AbstractBaseManager;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.oid.IDBroker;
import org.apache.torque.oid.IDGeneratorFactory;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.BasePeerImpl;
import org.apache.torque.util.Transaction;
import org.apache.torque.util.TransactionManager;
import org.apache.torque.util.TransactionManagerImpl;

public class TorqueInstance {
    private static final Logger log = LogManager.getLogger(TorqueInstance.class);
    private static final String DEFAULT_NAME = "default";
    private String defaultDBName = null;
    private final ConcurrentMap<String, Database> databases = new ConcurrentHashMap<String, Database>();
    private final ConcurrentMap<String, AbstractBaseManager<?>> managers = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, BasePeerImpl<?>> peers = new ConcurrentHashMap();
    private final Set<IDBroker> idBrokers = new HashSet<IDBroker>();
    private Configuration conf;
    private boolean isInit = false;
    private boolean defaultDsfIsReference = false;

    public TorqueInstance() {
        this.resetConfiguration();
    }

    private void checkInit() throws TorqueException {
        if (!this.isInit()) {
            throw new TorqueException("Torque is not initialized.");
        }
    }

    private synchronized void initialize() throws TorqueException {
        log.debug("initialize()");
        if (this.isInit) {
            throw new TorqueException("Multiple initializations of Torque attempted");
        }
        if (this.conf == null || this.conf.isEmpty()) {
            throw new TorqueException("Torque cannot be initialized without a valid configuration. Please check the log files for further details.");
        }
        this.initTransactionManager(this.conf);
        this.initDefaultDbName(this.conf);
        this.initDataSourceFactories(this.conf);
        this.initSchemata(this.conf);
        this.initAdapters(this.conf);
        Database defaultDatabase = (Database)this.databases.get(this.defaultDBName);
        Database databaseInfoForKeyDefault = this.getOrCreateDatabase(DEFAULT_NAME);
        if (!this.defaultDBName.equals(DEFAULT_NAME) && databaseInfoForKeyDefault.getDataSourceFactory() == null) {
            log.debug("Adding the DatasourceFactory and DatabaseAdapter from database {} onto database {}", new Supplier[]{() -> this.defaultDBName, () -> DEFAULT_NAME});
            databaseInfoForKeyDefault.setDataSourceFactory(defaultDatabase.getDataSourceFactory());
            databaseInfoForKeyDefault.setAdapter(defaultDatabase.getAdapter());
            this.defaultDsfIsReference = true;
        }
        this.initManagerMappings(this.conf);
        this.isInit = true;
        this.startIdBrokers();
    }

    private void initTransactionManager(Configuration conf) throws TorqueException {
        TransactionManager transactionManager;
        log.debug("initTransactionManager({})", (Object)conf);
        String transactionManagerClassName = conf.getString("transactionManager");
        if (StringUtils.isEmpty((CharSequence)transactionManagerClassName)) {
            if (log.isTraceEnabled()) {
                log.trace("Configuration key {}.{} not set, using default transaction manager {}", (Object)"torque", (Object)"transactionManager", (Object)TransactionManagerImpl.class.getName());
            }
            transactionManager = new TransactionManagerImpl();
        } else {
            try {
                Class<?> transactionManagerClass = Class.forName(transactionManagerClassName);
                transactionManager = (TransactionManager)transactionManagerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (log.isTraceEnabled()) {
                    log.trace("Using transaction manager {}", (Object)transactionManager.getClass().getName());
                }
            }
            catch (Exception e) {
                log.error("Error handling transaction manager configuration", (Throwable)e);
                throw new TorqueException(e);
            }
        }
        Transaction.setTransactionManager(transactionManager);
    }

    private void initDefaultDbName(Configuration conf) throws TorqueException {
        log.debug("initDefaultDbName({})", (Object)conf);
        this.defaultDBName = conf.getString("database.default");
        if (this.defaultDBName == null) {
            String error = "Invalid configuration: Key torque.database.default not set";
            log.error(error);
            throw new TorqueException(error);
        }
    }

    private void initAdapters(Configuration conf) throws TorqueException {
        log.debug("initAdapters({})", (Object)conf);
        Configuration c = conf.subset("database");
        if (c == null || c.isEmpty()) {
            String error = "Invalid configuration : No keys starting with torque.database found in configuration";
            log.error(error);
            throw new TorqueException(error);
        }
        try {
            Iterator it = c.getKeys();
            while (it.hasNext()) {
                Connection con;
                Adapter adapter;
                Database database;
                String handle;
                String adapterKey;
                String key;
                block24: {
                    key = (String)it.next();
                    if (!key.endsWith("adapter") && !key.endsWith("driver")) continue;
                    adapterKey = c.getString(key);
                    handle = key.substring(0, key.indexOf(46));
                    database = this.getOrCreateDatabase(handle);
                    adapter = null;
                    if (StringUtils.equals((CharSequence)"auto", (CharSequence)adapterKey)) {
                        try {
                            con = database.getDataSourceFactory().getDataSource().getConnection();
                            try {
                                adapter = AdapterFactory.autoDetectAdapter(con);
                                break block24;
                            }
                            finally {
                                if (con != null) {
                                    con.close();
                                }
                            }
                        }
                        catch (SQLException e) {
                            log.error("Could not get product information from JDBC", (Throwable)e);
                            throw new InstantiationException(e.getMessage());
                        }
                    }
                    adapter = AdapterFactory.create(adapterKey);
                }
                if (adapter == null) {
                    String adapterClassName = c.getString(key + "." + adapterKey + ".className", null);
                    adapter = AdapterFactory.create(adapterKey, adapterClassName);
                }
                database.setAdapter(adapter);
                log.debug("Adding {} -> {} as Adapter", (Object)adapterKey, (Object)handle);
                try {
                    con = database.getDataSourceFactory().getDataSource().getConnection();
                    try {
                        AdapterFactory.setCapabilities(con, adapter);
                    }
                    finally {
                        if (con != null) {
                            con.close();
                        }
                    }
                }
                catch (SQLException e) {
                    log.debug("Could not get database meta data from JDBC");
                }
                for (IDMethod idMethod : IDGeneratorFactory.ID_GENERATOR_METHODS) {
                    database.addIdGenerator(idMethod, IDGeneratorFactory.create(adapter, handle));
                }
            }
        }
        catch (InstantiationException e) {
            log.error("Error creating a database adapter instance", (Throwable)e);
            throw new TorqueException(e);
        }
        Database defaultDatabase = (Database)this.databases.get(this.getDefaultDB());
        if (defaultDatabase == null || defaultDatabase.getAdapter() == null) {
            String error = "Invalid configuration : No adapter definition found for default DB An adapter must be defined under torque.database." + this.getDefaultDB() + ".adapter";
            log.error(error);
            throw new TorqueException(error);
        }
    }

    private void initDataSourceFactories(Configuration conf) throws TorqueException {
        log.debug("initDataSourceFactories({})", (Object)conf);
        Configuration c = conf.subset("dsfactory");
        if (c == null || c.isEmpty()) {
            String error = "Invalid configuration: No keys starting with torque.dsfactory found in configuration";
            log.error(error);
            throw new TorqueException(error);
        }
        try {
            Iterator it = c.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!key.endsWith("factory")) continue;
                String classname = c.getString(key);
                String handle = key.substring(0, key.indexOf(46));
                log.debug("handle: {} DataSourceFactory: {}", (Object)handle, (Object)classname);
                Class<?> dsfClass = Class.forName(classname);
                DataSourceFactory dsf = (DataSourceFactory)dsfClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Configuration subConf = c.subset(handle);
                dsf.initialize(subConf);
                Database database = this.getOrCreateDatabase(handle);
                database.setDataSourceFactory(dsf);
            }
        }
        catch (RuntimeException e) {
            log.error("Error reading DataSourceFactory configuration", (Throwable)e);
            throw new TorqueRuntimeException(e);
        }
        catch (Exception e) {
            log.error("Error reading DataSourceFactory configuration", (Throwable)e);
            throw new TorqueException(e);
        }
        Database defaultDatabase = (Database)this.databases.get(this.defaultDBName);
        if (defaultDatabase == null || defaultDatabase.getDataSourceFactory() == null) {
            String error = "Invalid configuration : No DataSourceFactory definition for default DB found. A DataSourceFactory must be defined under the keytorque.dsfactory." + this.defaultDBName + ".factory";
            log.error(error);
            throw new TorqueException(error);
        }
    }

    private void initSchemata(Configuration conf) throws TorqueException {
        log.debug("initSchemata({})", (Object)conf);
        Configuration c = conf.subset("database");
        if (c == null || c.isEmpty()) {
            String error = "Invalid configuration: No keys starting with torque.database found in configuration";
            log.error(error);
            throw new TorqueException(error);
        }
        try {
            Iterator it = c.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                int indexOfDot = key.indexOf(46);
                if (indexOfDot == -1) continue;
                String handle = key.substring(0, indexOfDot);
                log.debug("database handle: {}", (Object)handle);
                Configuration subConf = c.subset(handle);
                Database database = this.getOrCreateDatabase(handle);
                String schema = subConf.getString("schema", null);
                if (StringUtils.isEmpty((CharSequence)schema)) {
                    schema = database.getSchema();
                }
                if (StringUtils.isEmpty((CharSequence)schema)) {
                    schema = conf.getString("defaults.schema", null);
                }
                database.setSchema(schema);
            }
        }
        catch (RuntimeException e) {
            log.error("Error reading DataSourceFactory configuration", (Throwable)e);
            throw new TorqueRuntimeException(e);
        }
        catch (Exception e) {
            log.error("Error reading DataSourceFactory configuration", (Throwable)e);
            throw new TorqueException(e);
        }
    }

    public void init(String configFile) throws TorqueException {
        log.debug("init({})", (Object)configFile);
        try {
            Configuration configuration;
            if (!configFile.endsWith("xml")) {
                FileBasedConfigurationBuilder propertiesBuilder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setFileName(configFile)).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','))});
                configuration = (Configuration)propertiesBuilder.getConfiguration();
            } else {
                CombinedConfigurationBuilder combinedBuilder = new CombinedConfigurationBuilder().configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)new Parameters().fileBased().setFileName(configFile)).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','))});
                configuration = (Configuration)combinedBuilder.getConfiguration();
            }
            log.debug("Config Object is {}", (Object)configuration);
            this.init(configuration);
        }
        catch (ConfigurationException e) {
            throw new TorqueException(e);
        }
    }

    public synchronized void init(Configuration conf) throws TorqueException {
        log.debug("init({})", (Object)conf);
        this.setConfiguration(conf);
        this.initialize();
    }

    protected synchronized void initManagerMappings(Configuration conf) throws TorqueException {
        int pref = "managed_class.".length();
        int suff = ".manager".length();
        Iterator it = conf.getKeys();
        while (it.hasNext()) {
            String managedClassKey;
            String key = (String)it.next();
            if (!key.startsWith("managed_class.") || !key.endsWith(".manager") || this.managers.containsKey(managedClassKey = key.substring(pref, key.length() - suff))) continue;
            String managerClass = conf.getString(key);
            log.info("Added Manager for Class: {} -> {}", (Object)managedClassKey, (Object)managerClass);
            try {
                this.initManager(managedClassKey, managerClass);
            }
            catch (TorqueException e) {
                log.error("", (Throwable)e);
                e.printStackTrace();
                throw e;
            }
        }
    }

    private void initManager(String name, String className) throws TorqueException {
        this.managers.computeIfAbsent(name, key -> {
            if (StringUtils.isNotEmpty((CharSequence)className)) {
                try {
                    return (AbstractBaseManager)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new TorqueRuntimeException("Could not instantiate manager associated with class: " + key, e);
                }
            }
            return null;
        });
    }

    private void startIdBrokers() {
        this.idBrokers.forEach(IDBroker::start);
    }

    public boolean isInit() {
        return this.isInit;
    }

    public void setConfiguration(Configuration conf) throws TorqueException {
        log.debug("setConfiguration({})", (Object)conf);
        Configuration subConf = conf.subset("torque");
        if (subConf == null || subConf.isEmpty()) {
            String error = "Invalid configuration. No keys starting with torque found in configuration";
            log.error(error);
            throw new TorqueException(error);
        }
        this.conf = subConf;
    }

    public Configuration getConfiguration() {
        log.debug("getConfiguration() = {}", (Object)this.conf);
        return this.conf;
    }

    public <T extends AbstractBaseManager<? extends Persistent>> T getManager(String name) {
        AbstractBaseManager m = (AbstractBaseManager)this.managers.get(name);
        if (m == null) {
            log.error("No configured manager for key {}.", (Object)name);
        }
        return (T)m;
    }

    public <T extends AbstractBaseManager<? extends Persistent>> T getManager(String name, String defaultClassName) {
        AbstractBaseManager m = (AbstractBaseManager)this.managers.get(name);
        if (m == null) {
            log.debug("Added late Manager mapping for Class: {} -> {}", (Object)name, (Object)defaultClassName);
            try {
                this.initManager(name, defaultClassName);
            }
            catch (TorqueException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            m = (AbstractBaseManager)this.managers.get(name);
        }
        return (T)m;
    }

    public <T> void registerPeerInstance(Class<T> omClass, BasePeerImpl<T> peerInstance) {
        this.peers.put(omClass, peerInstance);
    }

    public <T, P extends BasePeerImpl<T>> P getPeerInstance(Class<T> omClass) {
        BasePeerImpl p = (BasePeerImpl)this.peers.get(omClass);
        if (p == null) {
            log.error("No registered peer for class {}.", omClass);
        }
        return (P)p;
    }

    public synchronized void shutdown() throws TorqueException {
        this.idBrokers.forEach(IDBroker::stop);
        this.managers.values().forEach(AbstractBaseManager::dispose);
        JCS.shutdown();
        TorqueException exception = null;
        for (Map.Entry databaseMapEntry : this.databases.entrySet()) {
            Object databaseKey = databaseMapEntry.getKey();
            Database database = (Database)databaseMapEntry.getValue();
            if (DEFAULT_NAME.equals(databaseKey) && this.defaultDsfIsReference) {
                database.setDataSourceFactory(null);
                continue;
            }
            try {
                DataSourceFactory dataSourceFactory = database.getDataSourceFactory();
                if (dataSourceFactory == null) continue;
                dataSourceFactory.close();
                database.setDataSourceFactory(null);
            }
            catch (TorqueException e) {
                log.error("Error while closing the DataSourceFactory {}", databaseKey, (Object)e);
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
        this.resetConfiguration();
    }

    private void resetConfiguration() {
        this.managers.clear();
        this.peers.clear();
        this.isInit = false;
    }

    public DatabaseMap getDatabaseMap() throws TorqueException {
        String name = this.getDefaultDB();
        if (name == null) {
            throw new TorqueException("Torque is not initialized");
        }
        return this.getDatabaseMap(name);
    }

    public DatabaseMap getDatabaseMap(String name) throws TorqueException {
        if (name == null) {
            this.checkInit();
            name = this.getDefaultDB();
        }
        Database database = this.getOrCreateDatabase(name);
        return database.getDatabaseMap();
    }

    public void registerIDBroker(IDBroker idBroker) {
        this.idBrokers.add(idBroker);
        if (this.isInit()) {
            idBroker.start();
        }
    }

    public Connection getConnection() throws TorqueException {
        return this.getConnection(this.getDefaultDB());
    }

    public Connection getConnection(String name) throws TorqueException {
        this.checkInit();
        try {
            return this.getDatabase(name).getDataSourceFactory().getDataSource().getConnection();
        }
        catch (SQLException se) {
            throw new TorqueException(se);
        }
    }

    public DataSourceFactory getDataSourceFactory(String name) throws TorqueException {
        this.checkInit();
        Database database = this.getDatabase(name);
        DataSourceFactory dsf = null;
        if (database != null) {
            dsf = database.getDataSourceFactory();
        }
        if (dsf == null) {
            throw new TorqueException("There was no DataSourceFactory configured for the connection " + name);
        }
        return dsf;
    }

    public Connection getConnection(String name, String username, String password) throws TorqueException {
        this.checkInit();
        try {
            return this.getDataSourceFactory(name).getDataSource().getConnection(username, password);
        }
        catch (SQLException se) {
            throw new TorqueException(se);
        }
    }

    public Adapter getAdapter(String name) throws TorqueException {
        this.checkInit();
        Database database = this.getDatabase(name);
        if (database == null) {
            return null;
        }
        return database.getAdapter();
    }

    public String getDefaultDB() {
        return this.defaultDBName;
    }

    public void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.error("Error occured while closing connection.", (Throwable)e);
            }
        }
    }

    public void setSchema(String name, String schema) {
        this.getOrCreateDatabase(name).setSchema(schema);
    }

    public String getSchema(String name) throws TorqueException {
        this.checkInit();
        Database database = this.getDatabase(name);
        if (database == null) {
            return null;
        }
        return database.getSchema();
    }

    public Database getDatabase(String databaseName) throws TorqueException {
        this.checkInit();
        if (databaseName == null) {
            databaseName = this.getDefaultDB();
        }
        return (Database)this.databases.get(databaseName);
    }

    public Map<String, Database> getDatabases() throws TorqueException {
        this.checkInit();
        return Collections.unmodifiableMap(this.databases);
    }

    public Database getOrCreateDatabase(String databaseName) {
        if (databaseName == null) {
            throw new NullPointerException("databaseName is null");
        }
        return this.databases.computeIfAbsent(databaseName, Database::new);
    }
}

