/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils.publicsuffixlist;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import nl.basjes.parse.useragent.utils.publicsuffixlist.DomainType;
import nl.basjes.parse.useragent.utils.publicsuffixlist.PublicSuffixList;
import nl.basjes.parse.useragent.utils.publicsuffixlist.PublicSuffixListParser;
import nl.basjes.parse.useragent.utils.publicsuffixlist.PublicSuffixMatcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PublicSuffixMatcherLoader {
    private static final Logger LOG = LogManager.getLogger(PublicSuffixMatcherLoader.class);
    private static volatile PublicSuffixMatcher defaultInstance;
    private static final String DEFAULT_FILENAME = "/mozilla-public-suffix-list.txt";

    private PublicSuffixMatcherLoader() {
    }

    private static PublicSuffixMatcher load(InputStream in) throws IOException {
        List<PublicSuffixList> lists = PublicSuffixListParser.INSTANCE.parseByType(new InputStreamReader(in, StandardCharsets.UTF_8));
        return new PublicSuffixMatcher(lists);
    }

    public static PublicSuffixMatcher load(@Nonnull URL url) throws IOException {
        try (InputStream in = url.openStream();){
            PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.load(in);
            return publicSuffixMatcher;
        }
    }

    public static PublicSuffixMatcher load(@Nonnull File file) throws IOException {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.load(in);
            return publicSuffixMatcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PublicSuffixMatcher getDefault() {
        if (defaultInstance != null) return defaultInstance;
        Class<PublicSuffixMatcherLoader> clazz = PublicSuffixMatcherLoader.class;
        synchronized (PublicSuffixMatcherLoader.class) {
            if (defaultInstance != null) return defaultInstance;
            URL url = PublicSuffixMatcherLoader.class.getResource(DEFAULT_FILENAME);
            if (url != null) {
                try {
                    defaultInstance = PublicSuffixMatcherLoader.load(url);
                }
                catch (IOException ex) {
                    LOG.warn("Failure loading public suffix list from default resource", (Throwable)ex);
                }
            } else {
                defaultInstance = new PublicSuffixMatcher(DomainType.ICANN, Collections.singletonList("com"), null);
                throw new IllegalStateException("Unable to load the needed file /mozilla-public-suffix-list.txt");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultInstance;
        }
    }
}

