/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import java.util.Set;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.MatcherAction;
import nl.basjes.parse.useragent.analyze.treewalker.steps.WalkList;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerParser;
import nl.basjes.parse.useragent.yauaa.shaded.org.antlr.v4.runtime.ParserRuleContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MatcherVariableAction
extends MatcherAction {
    private static final Logger LOG = LogManager.getLogger(MatcherVariableAction.class);
    private final String variableName;
    private transient WalkList.WalkResult foundValue = null;
    private Set<MatcherAction> interestedActions;

    private MatcherVariableAction() {
        this.variableName = null;
    }

    public MatcherVariableAction(String variableName, String config, Matcher matcher) {
        this.variableName = variableName;
        this.init(config, matcher);
    }

    @Override
    protected ParserRuleContext parseWalkerExpression(UserAgentTreeWalkerParser parser) {
        return parser.matcherVariable();
    }

    @Override
    protected void setFixedValue(String fixedValue) {
        throw new InvalidParserConfigurationException("It is useless to put a fixed value \"" + fixedValue + "\" in the variable section.");
    }

    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public void inform(String key, WalkList.WalkResult newlyFoundValue) {
        if (this.verbose) {
            LOG.info("INFO  : VARIABLE ({}): {}", (Object)this.variableName, (Object)key);
            LOG.info("NEED  : VARIABLE ({}): {}", (Object)this.variableName, (Object)this.getMatchExpression());
        }
        if (this.foundValue == null) {
            this.foundValue = newlyFoundValue;
            if (this.verbose) {
                LOG.info("KEPT  : VARIABLE ({}): {}", (Object)this.variableName, (Object)key);
            }
            if (this.interestedActions != null && !this.interestedActions.isEmpty()) {
                for (MatcherAction action : this.interestedActions) {
                    action.inform(this.variableName, newlyFoundValue.getValue(), newlyFoundValue.getTree());
                }
            }
        }
    }

    @Override
    public boolean obtainResult() {
        this.processInformedMatches();
        return this.foundValue != null;
    }

    @Override
    public void reset() {
        super.reset();
        this.foundValue = null;
    }

    @Override
    public String toString() {
        return "Variable.(" + this.matcher.getMatcherSourceLocation() + "): (" + this.variableName + "): " + this.getMatchExpression();
    }

    public void setInterestedActions(Set<MatcherAction> newInterestedActions) {
        this.interestedActions = newInterestedActions;
    }
}

