/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.pool.PoolException;
import org.apache.fulcrum.pool.PoolService;
import org.apache.fulcrum.security.model.turbine.TurbineAccessControlList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.annotation.TurbineLoader;
import org.apache.turbine.annotation.TurbineRequiredPermission;
import org.apache.turbine.annotation.TurbineRequiredRole;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.annotation.TurbineTool;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.services.ServiceManager;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.util.TurbineException;

public class AnnotationProcessor {
    private static Logger log = LogManager.getLogger(AnnotationProcessor.class);
    private static ConcurrentMap<String, Annotation[]> annotationCache = new ConcurrentHashMap<String, Annotation[]>();

    public static Annotation[] getAnnotations(AccessibleObject object) {
        Annotation[] newAnnotations;
        String key = object.getClass() + object.toString();
        Annotation[] annotations = (Annotation[])annotationCache.get(key);
        if (annotations == null && (annotations = annotationCache.putIfAbsent(key, newAnnotations = object.getDeclaredAnnotations())) == null) {
            annotations = newAnnotations;
        }
        return annotations;
    }

    public static <A extends TurbineAccessControlList<?>> boolean isAuthorized(AccessibleObject object, A acl) {
        return AnnotationProcessor.isAuthorized(object, acl, ConditionType.COMPOUND);
    }

    public static <A extends TurbineAccessControlList<?>> boolean isAuthorized(AccessibleObject object, A acl, ConditionType conditonType) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = AnnotationProcessor.getAnnotations(object)) {
            String group;
            if (annotation instanceof TurbineRequiredRole) {
                TurbineRequiredRole trr = (TurbineRequiredRole)annotation;
                String[] roleNames = trr.value();
                group = trr.group();
                if (StringUtils.isEmpty((CharSequence)group)) {
                    block13: for (String roleName : roleNames) {
                        switch (conditonType) {
                            default: {
                                if (acl.hasRole(roleName)) continue block13;
                                return false;
                            }
                            case ANY: {
                                if (!acl.hasRole(roleName)) continue block13;
                                return true;
                            }
                        }
                    }
                    if (conditonType != ConditionType.ANY) continue;
                    return false;
                }
                block14: for (String roleName : roleNames) {
                    switch (conditonType) {
                        default: {
                            if (acl.hasRole(roleName, group)) continue block14;
                            return false;
                        }
                        case ANY: {
                            if (!acl.hasRole(roleName, group)) continue block14;
                            return true;
                        }
                    }
                }
                continue;
            }
            if (!(annotation instanceof TurbineRequiredPermission)) continue;
            TurbineRequiredPermission trp = (TurbineRequiredPermission)annotation;
            String[] permissionNames = trp.value();
            group = trp.group();
            if (StringUtils.isEmpty((CharSequence)group)) {
                block15: for (String permissionName : permissionNames) {
                    switch (conditonType) {
                        default: {
                            if (acl.hasPermission(permissionName)) continue block15;
                            return false;
                        }
                        case ANY: {
                            if (!acl.hasPermission(permissionName)) continue block15;
                            return true;
                        }
                    }
                }
                continue;
            }
            block16: for (String permissionName : permissionNames) {
                switch (conditonType) {
                    default: {
                        if (acl.hasPermission(permissionName, group)) continue block16;
                        return false;
                    }
                    case ANY: {
                        if (!acl.hasPermission(permissionName, group)) continue block16;
                        return true;
                    }
                }
            }
        }
        return true;
    }

    public static void process(Object object) throws TurbineException {
        AnnotationProcessor.process(object, false);
    }

    public static void process(Object object, Boolean hasTurbineServicesInMethodFields) throws TurbineException {
        ServiceManager manager = null;
        Configuration config = null;
        AssemblerBrokerService assembler = null;
        PoolService pool = null;
        Class<?> clazz = object.getClass();
        boolean isTurbineService = false;
        if (clazz.isAnnotationPresent(TurbineService.class)) {
            TurbineService service = clazz.getAnnotation(TurbineService.class);
            log.debug("retrieved class annotation: " + service);
            isTurbineService = true;
        }
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Annotation[] annotations;
                for (Annotation a : annotations = AnnotationProcessor.getAnnotations(field)) {
                    if (a instanceof TurbineService) {
                        if (manager == null) {
                            manager = TurbineServices.getInstance();
                        }
                        AnnotationProcessor.injectTurbineService(object, manager, field, (TurbineService)a);
                        continue;
                    }
                    if (a instanceof TurbineConfiguration) {
                        if (config == null) {
                            config = Turbine.getConfiguration();
                        }
                        AnnotationProcessor.injectTurbineConfiguration(object, config, field, (TurbineConfiguration)a);
                        continue;
                    }
                    if (a instanceof TurbineLoader) {
                        if (assembler == null) {
                            assembler = (AssemblerBrokerService)TurbineServices.getInstance().getService("AssemblerBrokerService");
                        }
                        AnnotationProcessor.injectTurbineLoader(object, assembler, field, (TurbineLoader)a);
                        continue;
                    }
                    if (!(a instanceof TurbineTool)) continue;
                    if (pool == null) {
                        pool = (PoolService)TurbineServices.getInstance().getService(PoolService.ROLE);
                    }
                    AnnotationProcessor.injectTurbineTool(object, pool, field, (TurbineTool)a);
                }
                if (!isTurbineService || !field.getType().isAnnotationPresent(TurbineService.class)) continue;
                TurbineService service = field.getType().getAnnotation(TurbineService.class);
                log.debug("retrieved implicit class annotation: " + service);
                if (manager == null) {
                    manager = TurbineServices.getInstance();
                }
                AnnotationProcessor.injectTurbineService(object, manager, field, service);
            }
            if (hasTurbineServicesInMethodFields.booleanValue()) {
                manager = AnnotationProcessor.processMethods(object, manager, clazz, isTurbineService);
            }
            clazz = clazz.getSuperclass();
        }
    }

    private static ServiceManager processMethods(Object object, ServiceManager manager, Class<?> clazz, boolean isTurbineService) throws TurbineException {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            Class<?>[] classes;
            Annotation[] annotations;
            for (Annotation a : annotations = AnnotationProcessor.getAnnotations(method)) {
                if (!(a instanceof TurbineService)) continue;
                if (manager == null) {
                    manager = TurbineServices.getInstance();
                }
                AnnotationProcessor.injectTurbineService(object, manager, method, (TurbineService)a);
            }
            if (!isTurbineService) continue;
            if (manager == null) {
                manager = TurbineServices.getInstance();
            }
            for (Class<?> c : classes = method.getParameterTypes()) {
                if (!c.isAnnotationPresent(TurbineService.class)) continue;
                TurbineService service = c.getAnnotation(TurbineService.class);
                log.debug("retrieved implicit service in Turbien service: " + service);
                AnnotationProcessor.injectTurbineService(object, manager, method, service);
            }
        }
        return manager;
    }

    private static void injectTurbineLoader(Object object, AssemblerBrokerService assembler, Field field, TurbineLoader annotation) throws TurbineException {
        Loader<? extends Assembler> loader = assembler.getLoader(annotation.value());
        field.setAccessible(true);
        try {
            log.debug("Injection of {} into object {}", loader, object);
            field.set(object, loader);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new TurbineException("Could not inject loader " + loader + " into object " + object, e);
        }
    }

    private static void injectTurbineTool(Object object, PoolService pool, Field field, TurbineTool annotation) throws TurbineException {
        Object tool = null;
        try {
            tool = pool.getInstance(annotation.value());
            AnnotationProcessor.process(tool);
            field.setAccessible(true);
            log.debug("Injection of {} into object {}", tool, object);
            field.set(object, tool);
        }
        catch (IllegalAccessException | IllegalArgumentException | PoolException e) {
            throw new TurbineException("Could not inject tool " + tool + " into object " + object, e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void injectTurbineConfiguration(Object object, Configuration conf, Field field, TurbineConfiguration annotation) throws TurbineException {
        Class<?> type = field.getType();
        String key = annotation.value();
        try {
            if (Configuration.class.isAssignableFrom(type)) {
                Configuration injectConfiguration = StringUtils.isNotEmpty((CharSequence)key) ? conf.subset(key) : conf;
                log.debug("Injection of {} into object {}", (Object)injectConfiguration, object);
                field.setAccessible(true);
                field.set(object, injectConfiguration);
                return;
            } else if (conf.containsKey(key)) {
                if (String.class.isAssignableFrom(type)) {
                    String value = conf.getString(key);
                    log.debug("Injection of key {} into object {}", (Object)value, object);
                    field.setAccessible(true);
                    field.set(object, value);
                    return;
                } else if (Boolean.TYPE.isAssignableFrom(type)) {
                    boolean value = conf.getBoolean(key);
                    log.debug("Injection of key {} into object {}", (Object)value, object);
                    field.setAccessible(true);
                    field.setBoolean(object, value);
                    return;
                } else if (Integer.TYPE.isAssignableFrom(type)) {
                    int value = conf.getInt(key);
                    log.debug("Injection of key {} into object {}", (Object)value, object);
                    field.setAccessible(true);
                    field.setInt(object, value);
                    return;
                } else if (Long.TYPE.isAssignableFrom(type)) {
                    long value = conf.getLong(key);
                    log.debug("Injection of key {} into object {}", (Object)value, object);
                    field.setAccessible(true);
                    field.setLong(object, value);
                    return;
                } else if (Short.TYPE.isAssignableFrom(type)) {
                    short value = conf.getShort(key);
                    log.debug("Injection of key {} into object {}", (Object)value, object);
                    field.setAccessible(true);
                    field.setShort(object, value);
                    return;
                } else if (Long.TYPE.isAssignableFrom(type)) {
                    long value = conf.getLong(key);
                    log.debug("Injection of key {} into object {}", (Object)value, object);
                    field.setAccessible(true);
                    field.setLong(object, value);
                    return;
                } else if (Float.TYPE.isAssignableFrom(type)) {
                    float value = conf.getFloat(key);
                    log.debug("Injection of key {} into object {}", (Object)Float.valueOf(value), object);
                    field.setAccessible(true);
                    field.setFloat(object, value);
                    return;
                } else if (Double.TYPE.isAssignableFrom(type)) {
                    double value = conf.getDouble(key);
                    log.debug("Injection of key {} into object {}", (Object)value, object);
                    field.setAccessible(true);
                    field.setDouble(object, value);
                    return;
                } else if (Byte.TYPE.isAssignableFrom(type)) {
                    byte value = conf.getByte(key);
                    log.debug("Injection of key {} into object {}", (Object)value, object);
                    field.setAccessible(true);
                    field.setByte(object, value);
                    return;
                } else {
                    if (!List.class.isAssignableFrom(type)) throw new TurbineException("Could not inject type " + type + " into object " + object + ". Type " + type + " not assignable in configuration " + conf + " (allowed: String, Boolean, List, Number Types, " + Configuration.class.getName() + ").");
                    List values = conf.getList(key);
                    log.debug("Injection of key {} into object {}", (Object)values, object);
                    field.setAccessible(true);
                    field.set(object, values);
                }
                return;
            } else {
                field.setAccessible(true);
                Object defaultValue = field.get(object);
                log.info("No key {} of type {} injected into object {}. Field {} is set to default {}.", (Object)key, type, object, (Object)field.getName(), defaultValue);
            }
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new TurbineException("Could not inject configuration " + conf + " into object " + object, e);
        }
    }

    private static void injectTurbineService(Object object, ServiceManager manager, Field field, TurbineService annotation) throws TurbineException {
        String serviceName = null;
        if (annotation != null && StringUtils.isNotEmpty((CharSequence)annotation.value())) {
            serviceName = annotation.value();
        } else {
            Field[] typeFields = field.getType().getFields();
            if (((serviceName = AnnotationProcessor.checkServiceOrRoleInField(serviceName, typeFields)) == null || serviceName.equals("Service")) && field.getType().isAnnotationPresent(TurbineService.class)) {
                TurbineService service = field.getType().getAnnotation(TurbineService.class);
                log.debug("retrieved class annotation: " + service);
                serviceName = service.value();
            }
        }
        if (StringUtils.isEmpty((CharSequence)serviceName)) {
            serviceName = field.getType().getName();
        }
        log.debug("Looking up service for injection: {} for object {}", (Object)serviceName, object);
        Object service = manager.getService(serviceName);
        field.setAccessible(true);
        try {
            log.debug("Injection of {} into object {}", (Object)serviceName, object);
            field.set(object, service);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new TurbineException("Could not inject service " + serviceName + " into object " + object, e);
        }
    }

    private static void injectTurbineService(Object object, ServiceManager manager, Method method, TurbineService annotation) throws TurbineException {
        String serviceName = null;
        if (annotation != null && StringUtils.isNotEmpty((CharSequence)annotation.value())) {
            serviceName = annotation.value();
        } else {
            Class<?>[] classes;
            for (Class<?> c : classes = method.getParameterTypes()) {
                Field[] fields = c.getFields();
                if ((serviceName = AnnotationProcessor.checkServiceOrRoleInField(serviceName, fields)) != null && !serviceName.equals("Service") || !c.isAnnotationPresent(TurbineService.class)) continue;
                TurbineService service = c.getAnnotation(TurbineService.class);
                log.debug("retrieved class annotation: " + service);
                serviceName = service.value();
            }
        }
        log.debug("Looking up service for injection: {} for object {}", (Object)serviceName, object);
        if (StringUtils.isEmpty((CharSequence)serviceName)) {
            serviceName = method.getName();
        }
        Object service = manager.getService(serviceName);
        method.setAccessible(true);
        try {
            log.debug("Injection of {} into object {}", (Object)serviceName, object);
            Object[] paramValues = new Object[]{service};
            method.invoke(object, paramValues);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new TurbineException("Could not inject service " + serviceName + " into object " + object, e);
        }
    }

    private static String checkServiceOrRoleInField(String serviceName, Field[] fields) {
        for (Field f : fields) {
            if ("SERVICE_NAME".equals(f.getName())) {
                try {
                    serviceName = (String)f.get(null);
                    break;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    continue;
                }
            }
            if (!"ROLE".equals(f.getName())) continue;
            try {
                serviceName = (String)f.get(null);
                break;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                // empty catch block
            }
        }
        return serviceName;
    }

    public static enum ConditionType {
        COMPOUND,
        ANY;

    }
}

