/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.uniqueid;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.uniqueid.UniqueIdService;
import org.apache.turbine.util.GenerateUniqueId;

public class TurbineUniqueIdService
extends TurbineBaseService
implements UniqueIdService {
    private static final Logger log = LogManager.getLogger(TurbineUniqueIdService.class);
    private static String turbineId = "UNKNOWN";
    private static String turbineURL = "UNKNOWN";
    private static AtomicInteger counter;

    @Override
    public void init() throws InitializationException {
        try {
            counter = new AtomicInteger();
            turbineURL = Turbine.getDefaultServerData().toString();
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytesId = md.digest(turbineURL.getBytes(StandardCharsets.UTF_8));
            turbineId = new String(Base64.encodeBase64((byte[])bytesId), StandardCharsets.UTF_8);
            log.info("This is Turbine instance running at: {}", (Object)turbineURL);
            log.info("The instance id is #{}", (Object)turbineId);
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("Could not initialize TurbineUniqueId Service", e);
        }
    }

    @Override
    public void shutdown() {
        log.info("Turbine instance running at {} shutting down.", (Object)turbineURL);
    }

    @Override
    public String getInstanceId() {
        return turbineId;
    }

    @Override
    public String getUniqueId() {
        int current = counter.getAndIncrement();
        String id = Integer.toString(current);
        if (current < 100000000) {
            id = ("00000000" + id).substring(id.length());
        }
        return id;
    }

    @Override
    public String getPseudorandomId() {
        return GenerateUniqueId.getIdentifier();
    }
}

