/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.screens;

import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.turbine.modules.screens.VelocityScreen;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class VelocityDirectScreen
extends VelocityScreen {
    @Override
    public String buildTemplate(PipelineData pipelineData) throws Exception {
        RunData data = pipelineData.getRunData();
        Context context = this.velocity.getContext(pipelineData);
        String screenTemplate = data.getTemplateInfo().getScreenTemplate();
        String templateName = this.templateService.getScreenTemplateName(screenTemplate);
        if (StringUtils.isEmpty((CharSequence)templateName)) {
            this.log.error("Screen " + screenTemplate + " not found!");
            throw new Exception("Could not find screen for " + screenTemplate);
        }
        try {
            this.velocity.handleRequest(context, "screens/" + templateName, (OutputStream)data.getResponse().getOutputStream());
        }
        catch (Exception e) {
            context.put("processingException", (Object)e.toString());
            context.put("stackTrace", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            this.velocity.handleRequest(context, "screens/" + this.templateError, (OutputStream)data.getResponse().getOutputStream());
        }
        return null;
    }
}

