/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.screens;

import org.apache.commons.lang3.StringUtils;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.screens.TemplateScreen;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.jsp.JspService;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.util.RunData;

public class BaseJspScreen
extends TemplateScreen {
    private static final String prefix = "screens/";
    @TurbineService
    private JspService jspService;
    @TurbineService
    private TemplateService templateService;

    @Override
    public String buildTemplate(PipelineData pipelineData) throws Exception {
        RunData data = pipelineData.getRunData();
        String screenTemplate = data.getTemplateInfo().getScreenTemplate();
        String templateName = this.templateService.getScreenTemplateName(screenTemplate);
        if (StringUtils.isEmpty((CharSequence)templateName)) {
            this.log.error("Screen " + screenTemplate + " not found!");
            throw new Exception("Could not find screen for " + screenTemplate);
        }
        this.jspService.handleRequest(pipelineData, prefix + templateName, this.getLayout(pipelineData) == null);
        return null;
    }

    @Override
    protected void doBuildTemplate(PipelineData pipelineData) throws Exception {
    }
}

