/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Column;
import org.apache.torque.ColumnImpl;
import org.apache.torque.Database;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.criteria.CriteriaInterface;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.criteria.FromElement;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.criteria.SqlEnum;
import org.apache.torque.map.ColumnMap;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.map.MapHelper;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.sql.JoinBuilder;
import org.apache.torque.sql.OrderBy;
import org.apache.torque.sql.Query;
import org.apache.torque.sql.WhereClauseExpression;
import org.apache.torque.sql.whereclausebuilder.CurrentDateTimePsPartBuilder;
import org.apache.torque.sql.whereclausebuilder.CustomBuilder;
import org.apache.torque.sql.whereclausebuilder.InBuilder;
import org.apache.torque.sql.whereclausebuilder.LikeBuilder;
import org.apache.torque.sql.whereclausebuilder.NullValueBuilder;
import org.apache.torque.sql.whereclausebuilder.StandardBuilder;
import org.apache.torque.sql.whereclausebuilder.VerbatimSqlConditionBuilder;
import org.apache.torque.sql.whereclausebuilder.WhereClausePsPartBuilder;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.UniqueColumnList;
import org.apache.torque.util.UniqueList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SqlBuilder {
    protected static final Log log = LogFactory.getLog(SqlBuilder.class);
    public static final String[] FUNCTION_DELIMITERS = new String[]{" ", ",", "(", ")", "<", ">"};
    private static final char BACKSLASH = '\\';
    private static List<WhereClausePsPartBuilder> whereClausePsPartBuilders = new ArrayList<WhereClausePsPartBuilder>();

    private SqlBuilder() {
    }

    public static List<WhereClausePsPartBuilder> getWhereClausePsPartBuilders() {
        return whereClausePsPartBuilders;
    }

    @Deprecated
    public static Query buildQuery(Criteria crit) throws TorqueException {
        Query sqlStatement = new Query();
        JoinBuilder.processJoins(crit, sqlStatement);
        SqlBuilder.processModifiers(crit, sqlStatement);
        SqlBuilder.processSelectColumns(crit, sqlStatement);
        SqlBuilder.processAsColumns(crit, sqlStatement);
        SqlBuilder.processCriterions(crit, sqlStatement);
        SqlBuilder.processGroupBy(crit, sqlStatement);
        SqlBuilder.processHaving(crit, sqlStatement);
        SqlBuilder.processOrderBy(crit, sqlStatement);
        SqlBuilder.processLimits(crit, sqlStatement);
        return sqlStatement;
    }

    public static Query buildQuery(org.apache.torque.criteria.Criteria crit) throws TorqueException {
        Query sqlStatement = new Query();
        JoinBuilder.processJoins(crit, sqlStatement);
        SqlBuilder.processModifiers(crit, sqlStatement);
        SqlBuilder.processSelectColumns(crit, sqlStatement);
        SqlBuilder.processAsColumns(crit, sqlStatement);
        SqlBuilder.processCriterions(crit, sqlStatement);
        SqlBuilder.processGroupBy(crit, sqlStatement);
        SqlBuilder.processHaving(crit, sqlStatement);
        SqlBuilder.processOrderBy(crit, sqlStatement);
        SqlBuilder.processLimits(crit, sqlStatement);
        SqlBuilder.processFromElements(crit, sqlStatement);
        SqlBuilder.processForUpdate(crit, sqlStatement);
        sqlStatement.setFetchSize(crit.getFetchSize());
        return sqlStatement;
    }

    private static void processSelectColumns(CriteriaInterface<?> criteria, Query query) throws TorqueException {
        UniqueList<String> selectClause = query.getSelectClause();
        UniqueColumnList selectColumns = criteria.getSelectColumns();
        for (Column column : selectColumns) {
            String sqlExpression = column.getSqlExpression();
            Column resolvedAlias = criteria.getAsColumns().get(sqlExpression);
            if (resolvedAlias != null) continue;
            selectClause.add(sqlExpression);
            SqlBuilder.addTableToFromClause(column, criteria, query);
        }
    }

    private static void processAsColumns(CriteriaInterface<?> criteria, Query query) throws TorqueException {
        UniqueList<String> querySelectClause = query.getSelectClause();
        Map<String, Column> criteriaAsColumns = criteria.getAsColumns();
        for (Map.Entry<String, Column> entry : criteriaAsColumns.entrySet()) {
            Column column = entry.getValue();
            querySelectClause.add(column.getSqlExpression() + SqlEnum.AS + entry.getKey());
            SqlBuilder.addTableToFromClause(column, criteria, query);
        }
    }

    private static void processModifiers(CriteriaInterface<?> criteria, Query query) {
        UniqueList<String> selectModifiers = query.getSelectModifiers();
        UniqueList<String> modifiers = criteria.getSelectModifiers();
        for (String modifier : modifiers) {
            selectModifiers.add(modifier);
        }
    }

    private static void processCriterions(org.apache.torque.criteria.Criteria criteria, Query query) throws TorqueException {
        if (criteria.getTopLevelCriterion() == null) {
            return;
        }
        StringBuilder where = new StringBuilder();
        SqlBuilder.appendCriterion(criteria.getTopLevelCriterion(), criteria, where, query);
        query.getWhereClause().add(where.toString());
    }

    static void appendCriterion(Criterion criterion, CriteriaInterface<?> criteria, StringBuilder where, Query query) throws TorqueException {
        if (criterion.isComposite()) {
            where.append('(');
            boolean firstPart = true;
            for (Criterion part : criterion.getParts()) {
                if (!firstPart) {
                    where.append(criterion.getConjunction());
                }
                SqlBuilder.appendCriterion(part, criteria, where, query);
                firstPart = false;
            }
            where.append(')');
            return;
        }
        SqlBuilder.addTableToFromClause(criterion.getLValue(), criteria, query);
        SqlBuilder.addTableToFromClause(criterion.getRValue(), criteria, query);
        PreparedStatementPart whereClausePartOutput = SqlBuilder.processCriterion(criterion, criteria);
        where.append((CharSequence)whereClausePartOutput.getSql());
        query.getWhereClausePreparedStatementReplacements().addAll(whereClausePartOutput.getPreparedStatementReplacements());
    }

    static PreparedStatementPart processCriterion(Criterion criterion, CriteriaInterface<?> criteria) throws TorqueException {
        String dbName = criteria.getDbName();
        Database database = Torque.getDatabase(dbName);
        Adapter adapter = Torque.getAdapter(dbName);
        boolean ignoreCase = SqlBuilder.isIgnoreCase(criterion, criteria, database);
        WhereClauseExpression whereClausePartInput = new WhereClauseExpression(criterion.getLValue(), criterion.getComparison(), criterion.getRValue(), criterion.getSql(), criterion.getPreparedStatementReplacements());
        PreparedStatementPart whereClausePartOutput = null;
        for (WhereClausePsPartBuilder builder : whereClausePsPartBuilders) {
            if (!builder.isApplicable(whereClausePartInput, adapter)) continue;
            whereClausePartOutput = builder.buildPs(whereClausePartInput, ignoreCase, adapter);
            break;
        }
        if (whereClausePartOutput == null) {
            throw new RuntimeException("No handler found for whereClausePart " + whereClausePartInput);
        }
        return whereClausePartOutput;
    }

    @Deprecated
    private static void processCriterions(Criteria criteria, Query query) throws TorqueException {
        UniqueList<String> whereClause = query.getWhereClause();
        for (Criteria.Criterion criterion : criteria.values()) {
            StringBuilder sb = new StringBuilder();
            SqlBuilder.appendCriterionToPs(criterion, criteria, sb, query);
            whereClause.add(sb.toString());
        }
    }

    @Deprecated
    private static void appendCriterionToPs(Criteria.Criterion criterion, Criteria criteria, StringBuilder sb, Query query) throws TorqueException {
        Column column = criterion.getColumn();
        SqlBuilder.addTableToFromClause(column, criteria, query);
        boolean ignoreCase = criteria.isIgnoreCase() || criterion.isIgnoreCase();
        String dbName = criteria.getDbName();
        Adapter adapter = Torque.getAdapter(dbName);
        Database database = Torque.getDatabase(dbName);
        Column databaseColumn = SqlBuilder.resolveAliasAndAsColumnAndSchema(column, criteria);
        ColumnMap columnMap = null;
        DatabaseMap databaseMap = database.getDatabaseMap();
        TableMap tableMap = databaseMap.getTable(databaseColumn.getTableName());
        if (tableMap != null) {
            columnMap = tableMap.getColumn(databaseColumn.getColumnName());
        }
        if (columnMap != null) {
            ignoreCase = ignoreCase && columnMap.getType() instanceof String;
        }
        for (int j = 0; j < criterion.getClauses().size(); ++j) {
            sb.append('(');
        }
        String columnName = criterion.getColumn().getSqlExpression();
        WhereClauseExpression whereClausePartInput = new WhereClauseExpression(columnName, criterion.getComparison(), criterion.getValue(), null, null);
        PreparedStatementPart whereClausePartOutput = SqlBuilder.buildPs(whereClausePartInput, ignoreCase, adapter);
        sb.append((CharSequence)whereClausePartOutput.getSql());
        query.getWhereClausePreparedStatementReplacements().addAll(whereClausePartOutput.getPreparedStatementReplacements());
        for (int i = 0; i < criterion.getClauses().size(); ++i) {
            sb.append(criterion.getConjunctions().get(i));
            Criteria.Criterion clause = criterion.getClauses().get(i);
            SqlBuilder.appendCriterionToPs(clause, criteria, sb, query);
            sb.append(')');
        }
    }

    private static void processOrderBy(CriteriaInterface<?> crit, Query query) throws TorqueException {
        UniqueList<String> orderByClause = query.getOrderByClause();
        UniqueList<String> selectClause = query.getSelectClause();
        UniqueList<OrderBy> orderByList = crit.getOrderByColumns();
        for (OrderBy orderBy : orderByList) {
            Column column = orderBy.getColumn();
            ColumnMap columnMap = MapHelper.getColumnMap(column, crit);
            String sqlExpression = column.getSqlExpression();
            if (columnMap == null || columnMap.getType() instanceof String && sqlExpression.indexOf(40) == -1) {
                if (orderBy.isIgnoreCase() || crit.isIgnoreCase()) {
                    Adapter adapter = Torque.getAdapter(crit.getDbName());
                    orderByClause.add(adapter.ignoreCaseInOrderBy(sqlExpression) + ' ' + orderBy.getOrder());
                    selectClause.add(adapter.ignoreCaseInOrderBy(sqlExpression));
                } else {
                    orderByClause.add(sqlExpression + ' ' + orderBy.getOrder());
                    if (crit.getAsColumns().get(sqlExpression) == null) {
                        selectClause.add(sqlExpression);
                    }
                }
            } else {
                orderByClause.add(sqlExpression + ' ' + orderBy.getOrder());
                if (crit.getAsColumns().get(sqlExpression) == null) {
                    selectClause.add(sqlExpression);
                }
            }
            SqlBuilder.addTableToFromClause(column, crit, query);
        }
    }

    private static void processGroupBy(CriteriaInterface<?> criteria, Query query) throws TorqueException {
        UniqueList<String> groupByClause = query.getGroupByClause();
        UniqueList<String> selectClause = query.getSelectClause();
        UniqueColumnList groupBy = criteria.getGroupByColumns();
        for (Column groupByColumn : groupBy) {
            Column column = criteria.getAsColumns().get(groupByColumn.getSqlExpression());
            if (column == null) {
                column = groupByColumn;
            }
            groupByClause.add(column.getSqlExpression());
            selectClause.add(column.getSqlExpression());
            SqlBuilder.addTableToFromClause(column, criteria, query);
        }
    }

    private static void processHaving(org.apache.torque.criteria.Criteria crit, Query query) throws TorqueException {
        Criterion having = crit.getHaving();
        if (having != null) {
            query.setHaving(having.toString());
        }
    }

    private static void processHaving(Criteria crit, Query query) throws TorqueException {
        Criteria.Criterion having = crit.getHaving();
        if (having != null) {
            query.setHaving(having.toString());
        }
    }

    private static void processLimits(CriteriaInterface<?> crit, Query query) throws TorqueException {
        int limit = crit.getLimit();
        long offset = crit.getOffset();
        if (offset > 0L || limit >= 0) {
            Adapter adapter = Torque.getAdapter(crit.getDbName());
            adapter.generateLimits(query, offset, limit);
        }
    }

    private static void processFromElements(org.apache.torque.criteria.Criteria criteria, Query query) {
        if (criteria.getFromElements().isEmpty()) {
            log.trace((Object)"criteria's from Elements is empty, using automatically calculated from clause");
            return;
        }
        query.getFromClause().clear();
        query.getFromClause().addAll(criteria.getFromElements());
    }

    private static void processForUpdate(org.apache.torque.criteria.Criteria criteria, Query query) throws TorqueException {
        if (criteria.isForUpdate()) {
            Adapter adapter = Torque.getAdapter(criteria.getDbName());
            query.setForUpdate(adapter.getUpdateLockClause());
        }
    }

    static PreparedStatementPart getExpressionForFromClause(Object toAddToFromClause, CriteriaInterface<?> criteria) throws TorqueException {
        if (!(toAddToFromClause instanceof Column)) {
            return new PreparedStatementPart("?", toAddToFromClause);
        }
        Column column = (Column)toAddToFromClause;
        Column resolvedColumn = SqlBuilder.resolveAliasAndAsColumnAndSchema(column, criteria);
        String fullTableName = resolvedColumn.getFullTableName();
        if (!StringUtils.equals((String)resolvedColumn.getTableName(), (String)column.getTableName())) {
            PreparedStatementPart result = new PreparedStatementPart();
            result.getSql().append(fullTableName).append(" ").append(column.getTableName());
            return result;
        }
        Object resolvedAlias = criteria.getAliases().get(resolvedColumn.getTableName());
        if (resolvedAlias != null) {
            if (resolvedAlias instanceof org.apache.torque.criteria.Criteria) {
                org.apache.torque.criteria.Criteria subquery = (org.apache.torque.criteria.Criteria)resolvedAlias;
                Query renderedSubquery = SqlBuilder.buildQuery(subquery);
                PreparedStatementPart result = new PreparedStatementPart();
                result.getSql().append("(").append(renderedSubquery.toString()).append(") ").append(resolvedColumn.getTableName());
                result.getPreparedStatementReplacements().addAll(renderedSubquery.getPreparedStatementReplacements());
                return result;
            }
            throw new TorqueException("Table name " + resolvedColumn.getTableName() + " resolved to an unhandleable class " + resolvedAlias.getClass().getName());
        }
        return new PreparedStatementPart(fullTableName, new Object[0]);
    }

    public static String getFullTableName(String table, String dbName) throws TorqueException {
        String targetDBName;
        String targetSchema;
        if (table == null) {
            return table;
        }
        int dotIndex = table.indexOf(".");
        if (dotIndex == -1 && StringUtils.isNotEmpty((String)(targetSchema = Torque.getSchema(targetDBName = dbName == null ? Torque.getDefaultDB() : dbName)))) {
            return new StringBuffer().append(targetSchema).append(".").append(table).toString();
        }
        return table;
    }

    public static String getUnqualifiedName(String name, String dbName) throws TorqueException {
        if (name == null) {
            return null;
        }
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex == -1) {
            return name;
        }
        return name.substring(dotIndex + 1);
    }

    public static String guessFullTableFromCriteria(org.apache.torque.criteria.Criteria criteria) throws TorqueException {
        Criterion criterion = criteria.getTopLevelCriterion();
        if (criterion == null) {
            throw new TorqueException("Could not determine table name  as criteria contains no criterion");
        }
        while (criterion.isComposite()) {
            criterion = criterion.getParts().iterator().next();
        }
        String tableName = null;
        Object lValue = criterion.getLValue();
        if (lValue instanceof Column) {
            Column column = (Column)lValue;
            tableName = column.getFullTableName();
        }
        if (tableName == null) {
            throw new TorqueException("Could not determine table name  as first criterion contains no table name");
        }
        return tableName;
    }

    public static TableMap getTableMap(String tableName, String dbName) throws TorqueException {
        DatabaseMap databaseMap;
        if (dbName == null) {
            dbName = Torque.getDefaultDB();
        }
        if ((databaseMap = Torque.getDatabaseMap(dbName)) == null) {
            throw new TorqueException("Could not find database map for database " + dbName);
        }
        String unqualifiedTableName = SqlBuilder.getUnqualifiedName(tableName, dbName);
        TableMap result = databaseMap.getTable(unqualifiedTableName);
        if (result == null) {
            throw new TorqueException("Could not find table " + tableName + " in database map of database " + dbName);
        }
        return result;
    }

    static Column resolveAliasAndAsColumnAndSchema(Column columnToResolve, CriteriaInterface<?> criteria) throws TorqueException {
        String resolvedTableName;
        String columnNameToResolve = columnToResolve.getColumnName();
        Column resolvedColumn = criteria.getAsColumns().get(columnNameToResolve);
        boolean sqlExpressionModified = false;
        if (resolvedColumn == null) {
            resolvedColumn = columnToResolve;
        } else {
            sqlExpressionModified = true;
        }
        String tableNameToResolve = resolvedColumn.getTableName();
        Object resolvedAlias = criteria.getAliases().get(tableNameToResolve);
        if (resolvedAlias == null || !(resolvedAlias instanceof String)) {
            resolvedTableName = tableNameToResolve;
        } else {
            resolvedTableName = (String)resolvedAlias;
            sqlExpressionModified = true;
        }
        String resolvedSchemaName = resolvedColumn.getSchemaName();
        if (resolvedSchemaName == null) {
            String dbName = criteria.getDbName();
            Database database = Torque.getDatabase(dbName);
            resolvedSchemaName = database.getSchema();
        }
        if (sqlExpressionModified) {
            return new ColumnImpl(resolvedSchemaName, resolvedTableName, resolvedColumn.getColumnName());
        }
        return new ColumnImpl(resolvedSchemaName, resolvedTableName, resolvedColumn.getColumnName(), resolvedColumn.getSqlExpression());
    }

    static boolean fromClauseContainsExpression(UniqueList<FromElement> fromClause, PreparedStatementPart fromExpression) {
        if (fromExpression == null || fromExpression.getSql().length() == 0) {
            return false;
        }
        String fromExpressionSql = fromExpression.getSql().toString();
        for (FromElement fromElement : fromClause) {
            if (!fromExpressionSql.equals(fromElement.getFromExpression())) continue;
            return true;
        }
        return false;
    }

    static void addTableToFromClause(Object possibleColumn, CriteriaInterface<?> criteria, Query query) throws TorqueException {
        if (possibleColumn == null) {
            return;
        }
        if (!(possibleColumn instanceof Column)) {
            return;
        }
        Column column = (Column)possibleColumn;
        if (column.getTableName() == null) {
            return;
        }
        PreparedStatementPart fromClauseExpression = SqlBuilder.getExpressionForFromClause(column, criteria);
        UniqueList<FromElement> queryFromClause = query.getFromClause();
        if (!SqlBuilder.fromClauseContainsExpression(queryFromClause, fromClauseExpression)) {
            FromElement fromElement = new FromElement(fromClauseExpression.getSql().toString(), null, null, fromClauseExpression.getPreparedStatementReplacements());
            queryFromClause.add(fromElement);
        }
    }

    static boolean isIgnoreCase(Criterion criterion, CriteriaInterface<?> criteria, Database database) throws TorqueException {
        boolean ignoreCase = criteria.isIgnoreCase() || criterion.isIgnoreCase();
        ignoreCase = ignoreCase && SqlBuilder.ignoreCaseApplicable(criterion.getLValue(), criteria, database) && SqlBuilder.ignoreCaseApplicable(criterion.getRValue(), criteria, database);
        return ignoreCase;
    }

    private static boolean ignoreCaseApplicable(Object value, CriteriaInterface<?> criteria, Database database) throws TorqueException {
        if (value == null) {
            return true;
        }
        if (!(value instanceof Column)) {
            return value instanceof String || value instanceof Iterable || value.getClass().isArray();
        }
        Column column = (Column)value;
        Column databaseColumn = SqlBuilder.resolveAliasAndAsColumnAndSchema(column, criteria);
        ColumnMap columnMap = null;
        DatabaseMap databaseMap = database.getDatabaseMap();
        TableMap tableMap = databaseMap.getTable(databaseColumn.getTableName());
        if (tableMap != null) {
            columnMap = tableMap.getColumn(databaseColumn.getColumnName());
        }
        if (columnMap == null) {
            return true;
        }
        return columnMap.getType() instanceof String;
    }

    @Deprecated
    private static PreparedStatementPart buildPs(WhereClauseExpression whereClausePart, boolean ignoreCase, Adapter adapter) throws TorqueException {
        PreparedStatementPart result = new PreparedStatementPart();
        if (SqlEnum.CUSTOM == whereClausePart.getOperator()) {
            result.getSql().append(whereClausePart.getRValue());
            return result;
        }
        if (whereClausePart.getRValue() instanceof SqlEnum) {
            result.getSql().append(whereClausePart.getLValue()).append(whereClausePart.getOperator()).append(whereClausePart.getRValue());
            return result;
        }
        if (whereClausePart.getRValue() instanceof ObjectKey) {
            whereClausePart.setRValue(((ObjectKey)whereClausePart.getRValue()).getValue());
        }
        if (whereClausePart.getRValue() == null) {
            if (whereClausePart.getOperator().equals(SqlEnum.EQUAL)) {
                result.getSql().append(whereClausePart.getLValue()).append(SqlEnum.ISNULL);
                return result;
            }
            if (whereClausePart.getOperator().equals(SqlEnum.NOT_EQUAL) || whereClausePart.getOperator().equals(SqlEnum.ALT_NOT_EQUAL)) {
                result.getSql().append(whereClausePart.getLValue()).append(SqlEnum.ISNOTNULL);
                return result;
            }
        }
        if (whereClausePart.getOperator().equals(SqlEnum.ISNULL) || whereClausePart.getOperator().equals(SqlEnum.ISNOTNULL)) {
            result.getSql().append(whereClausePart.getLValue()).append(whereClausePart.getOperator());
            return result;
        }
        if (whereClausePart.getRValue() instanceof org.apache.torque.criteria.Criteria) {
            Query subquery = SqlBuilder.buildQuery((org.apache.torque.criteria.Criteria)whereClausePart.getRValue());
            result.getPreparedStatementReplacements().addAll(subquery.getPreparedStatementReplacements());
            result.getSql().append(whereClausePart.getLValue()).append(whereClausePart.getOperator()).append("(").append(subquery.toString()).append(")");
            return result;
        }
        if (whereClausePart.getRValue() instanceof Criteria) {
            Query subquery = SqlBuilder.buildQuery((Criteria)whereClausePart.getRValue());
            result.getPreparedStatementReplacements().addAll(subquery.getPreparedStatementReplacements());
            result.getSql().append(whereClausePart.getLValue()).append(whereClausePart.getOperator()).append("(").append(subquery.toString()).append(")");
            return result;
        }
        if (whereClausePart.getOperator().equals(org.apache.torque.criteria.Criteria.LIKE) || whereClausePart.getOperator().equals(org.apache.torque.criteria.Criteria.NOT_LIKE) || whereClausePart.getOperator().equals(org.apache.torque.criteria.Criteria.ILIKE) || whereClausePart.getOperator().equals(org.apache.torque.criteria.Criteria.NOT_ILIKE)) {
            return SqlBuilder.buildPsLike(whereClausePart, ignoreCase, adapter);
        }
        if (whereClausePart.getOperator().equals(org.apache.torque.criteria.Criteria.IN) || whereClausePart.getOperator().equals(org.apache.torque.criteria.Criteria.NOT_IN)) {
            return SqlBuilder.buildPsIn(whereClausePart, ignoreCase, adapter);
        }
        result.getPreparedStatementReplacements().add(whereClausePart.getRValue());
        if (ignoreCase && whereClausePart.getRValue() instanceof String) {
            result.getSql().append(adapter.ignoreCase((String)whereClausePart.getLValue())).append(whereClausePart.getOperator()).append(adapter.ignoreCase("?"));
        } else {
            result.getSql().append(whereClausePart.getLValue()).append(whereClausePart.getOperator()).append("?");
        }
        return result;
    }

    @Deprecated
    static PreparedStatementPart buildPsLike(WhereClauseExpression whereClausePart, boolean ignoreCase, Adapter adapter) throws TorqueException {
        int position;
        if (!(whereClausePart.getRValue() instanceof String)) {
            throw new TorqueException("rValue must be a String for the operator " + whereClausePart.getOperator());
        }
        String value = (String)whereClausePart.getRValue();
        StringBuffer sb = new StringBuffer();
        boolean replaceWithEquals = true;
        for (position = 0; position < value.length(); ++position) {
            char checkWildcard = value.charAt(position);
            switch (checkWildcard) {
                case '\\': {
                    char escapedChar;
                    if (position + 1 >= value.length()) break;
                    if ((escapedChar = value.charAt(++position)) != '*' && escapedChar != '?') {
                        sb.append(checkWildcard);
                    }
                    checkWildcard = escapedChar;
                    break;
                }
                case '%': 
                case '_': {
                    replaceWithEquals = false;
                    break;
                }
                case '*': {
                    replaceWithEquals = false;
                    checkWildcard = '%';
                    break;
                }
                case '?': {
                    replaceWithEquals = false;
                    checkWildcard = '_';
                    break;
                }
            }
            sb.append(checkWildcard);
        }
        value = sb.toString();
        if (ignoreCase) {
            if (adapter.useIlike() && !replaceWithEquals) {
                if (SqlEnum.LIKE.equals(whereClausePart.getOperator())) {
                    whereClausePart.setOperator(SqlEnum.ILIKE);
                } else if (SqlEnum.NOT_LIKE.equals(whereClausePart.getOperator())) {
                    whereClausePart.setOperator(SqlEnum.NOT_ILIKE);
                }
            } else {
                whereClausePart.setLValue(adapter.ignoreCase((String)whereClausePart.getLValue()));
            }
        }
        PreparedStatementPart result = new PreparedStatementPart();
        result.getSql().append(whereClausePart.getLValue());
        if (replaceWithEquals) {
            if (whereClausePart.getOperator().equals(SqlEnum.NOT_LIKE) || whereClausePart.getOperator().equals(SqlEnum.NOT_ILIKE)) {
                result.getSql().append(SqlEnum.NOT_EQUAL);
            } else {
                result.getSql().append(SqlEnum.EQUAL);
            }
            sb = new StringBuffer();
            for (position = 0; position < value.length(); ++position) {
                char checkWildcard = value.charAt(position);
                if (checkWildcard == '\\' && position + 1 < value.length()) {
                    checkWildcard = value.charAt(++position);
                }
                sb.append(checkWildcard);
            }
            value = sb.toString();
        } else {
            result.getSql().append(whereClausePart.getOperator());
        }
        String rValueSql = "?";
        if (ignoreCase && (!adapter.useIlike() || replaceWithEquals)) {
            rValueSql = adapter.ignoreCase(rValueSql);
        }
        if (!replaceWithEquals && adapter.useEscapeClauseForLike()) {
            rValueSql = rValueSql + SqlEnum.ESCAPE + "'\\'";
        }
        result.getPreparedStatementReplacements().add(value);
        result.getSql().append(rValueSql);
        return result;
    }

    @Deprecated
    static PreparedStatementPart buildPsIn(WhereClauseExpression whereClausePart, boolean ignoreCase, Adapter adapter) {
        PreparedStatementPart result = new PreparedStatementPart();
        boolean ignoreCaseApplied = false;
        ArrayList<String> inClause = new ArrayList<String>();
        boolean nullContained = false;
        if (whereClausePart.getRValue() instanceof Iterable) {
            for (Object listValue : (Iterable)whereClausePart.getRValue()) {
                if (listValue == null) {
                    nullContained = true;
                    continue;
                }
                result.getPreparedStatementReplacements().add(listValue);
                if (ignoreCase && listValue instanceof String) {
                    inClause.add(adapter.ignoreCase("?"));
                    ignoreCaseApplied = true;
                    continue;
                }
                inClause.add("?");
            }
        } else if (whereClausePart.getRValue().getClass().isArray()) {
            for (Object arrayValue : (Object[])whereClausePart.getRValue()) {
                if (arrayValue == null) {
                    nullContained = true;
                    continue;
                }
                result.getPreparedStatementReplacements().add(arrayValue);
                if (ignoreCase && arrayValue instanceof String) {
                    inClause.add(adapter.ignoreCase("?"));
                    ignoreCaseApplied = true;
                    continue;
                }
                inClause.add("?");
            }
        } else {
            throw new IllegalArgumentException("Unknown rValue type " + whereClausePart.getRValue().getClass().getName() + ". rValue must be an instance of  Iterable or Array");
        }
        if (nullContained) {
            result.getSql().append('(');
        }
        if (ignoreCaseApplied) {
            result.getSql().append(adapter.ignoreCase((String)whereClausePart.getLValue()));
        } else {
            result.getSql().append(whereClausePart.getLValue());
        }
        result.getSql().append(whereClausePart.getOperator()).append('(').append(StringUtils.join(inClause.iterator(), (String)",")).append(')');
        if (nullContained) {
            if (whereClausePart.getOperator() == SqlEnum.IN) {
                result.getSql().append(" OR ").append(whereClausePart.getLValue()).append(SqlEnum.ISNULL);
            } else if (whereClausePart.getOperator() == SqlEnum.NOT_IN) {
                result.getSql().append(" AND ").append(whereClausePart.getLValue()).append(SqlEnum.ISNOTNULL);
            }
            result.getSql().append(')');
        }
        return result;
    }

    static {
        whereClausePsPartBuilders.add(new VerbatimSqlConditionBuilder());
        whereClausePsPartBuilders.add(new CustomBuilder());
        whereClausePsPartBuilders.add(new CurrentDateTimePsPartBuilder());
        whereClausePsPartBuilders.add(new NullValueBuilder());
        whereClausePsPartBuilders.add(new LikeBuilder());
        whereClausePsPartBuilders.add(new InBuilder());
        whereClausePsPartBuilders.add(new StandardBuilder());
    }
}

