/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.template;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.LayoutLoader;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.modules.NavigationLoader;
import org.apache.turbine.modules.PageLoader;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.factory.TurbineFactory;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.services.template.TemplateEngineService;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.services.template.mapper.BaseTemplateMapper;
import org.apache.turbine.services.template.mapper.ClassMapper;
import org.apache.turbine.services.template.mapper.DirectMapper;
import org.apache.turbine.services.template.mapper.DirectTemplateMapper;
import org.apache.turbine.services.template.mapper.LayoutTemplateMapper;
import org.apache.turbine.services.template.mapper.Mapper;
import org.apache.turbine.services.template.mapper.ScreenTemplateMapper;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class TurbineTemplateService
extends TurbineBaseService
implements TemplateService {
    private static Log log = LogFactory.getLog((Class)TurbineTemplateService.class);
    public static final int PAGE_KEY = 0;
    public static final String PAGE_NAME = "page";
    public static final int SCREEN_KEY = 1;
    public static final String SCREEN_NAME = "screen";
    public static final int LAYOUT_KEY = 2;
    public static final String LAYOUT_NAME = "layout";
    public static final int NAVIGATION_KEY = 3;
    public static final String NAVIGATION_NAME = "navigation";
    public static final int LAYOUT_TEMPLATE_KEY = 4;
    public static final String LAYOUT_TEMPLATE_NAME = "layout.template";
    public static final int SCREEN_TEMPLATE_KEY = 5;
    public static final String SCREEN_TEMPLATE_NAME = "screen.template";
    public static final int NAVIGATION_TEMPLATE_KEY = 6;
    public static final String NAVIGATION_TEMPLATE_NAME = "navigation.template";
    public static final int TEMPLATE_TYPES = 7;
    private Mapper[] mapperRegistry = null;
    protected static final String NO_FILE_EXT = "";
    private boolean useCache = false;
    private String defaultExtension;
    private String defaultTemplate;
    private Map templateEngineRegistry = null;

    public void init() throws InitializationException {
        Configuration config = this.getConfiguration();
        this.defaultExtension = config.getString("default.extension", NO_FILE_EXT);
        this.defaultTemplate = config.getString("default.template", "Default");
        this.useCache = Turbine.getConfiguration().getBoolean("module.cache", true);
        log.debug((Object)("Default Extension: " + this.defaultExtension));
        log.debug((Object)("Default Template:  " + this.defaultTemplate));
        log.debug((Object)("Use Caching:       " + this.useCache));
        this.templateEngineRegistry = Collections.synchronizedMap(new HashMap());
        this.initMapper(config);
        this.setInit(true);
    }

    public boolean isCaching() {
        return this.useCache;
    }

    public String getDefaultExtension() {
        return StringUtils.isNotEmpty((String)this.defaultExtension) ? this.defaultExtension : NO_FILE_EXT;
    }

    public String getExtension(String template) {
        if (StringUtils.isEmpty((String)template)) {
            return this.getDefaultExtension();
        }
        int dotIndex = template.indexOf(46);
        return dotIndex < 0 ? this.getDefaultExtension() : template.substring(dotIndex + 1);
    }

    public String getDefaultTemplate() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.defaultTemplate);
        if (StringUtils.isNotEmpty((String)this.defaultExtension)) {
            sb.append('.');
            sb.append(this.getDefaultExtension());
        }
        return sb.toString();
    }

    public String getDefaultPage() {
        return this.getDefaultPageName(this.getDefaultTemplate());
    }

    public String getDefaultScreen() {
        return this.getDefaultScreenName(this.getDefaultTemplate());
    }

    public String getDefaultLayout() {
        return this.getDefaultLayoutName(this.getDefaultTemplate());
    }

    public String getDefaultNavigation() {
        return this.getDefaultNavigationName(this.getDefaultTemplate());
    }

    public String getDefaultLayoutTemplate() {
        return this.getDefaultLayoutTemplateName(this.getDefaultTemplate());
    }

    public String getDefaultPageName(String template) {
        return this.mapperRegistry[0].getDefaultName(template);
    }

    public String getDefaultScreenName(String template) {
        return this.mapperRegistry[1].getDefaultName(template);
    }

    public String getDefaultLayoutName(String template) {
        return this.mapperRegistry[2].getDefaultName(template);
    }

    public String getDefaultNavigationName(String template) {
        return this.mapperRegistry[3].getDefaultName(template);
    }

    public String getDefaultLayoutTemplateName(String template) {
        return this.mapperRegistry[4].getDefaultName(template);
    }

    public String getDefaultPageName(RunData data) {
        String template = data.getParameters().get("template");
        return template != null ? this.getDefaultPageName(template) : this.getDefaultPage();
    }

    public String getDefaultLayoutName(RunData data) {
        String template = data.getParameters().get("template");
        return template != null ? this.getDefaultLayoutName(template) : this.getDefaultLayout();
    }

    public String getScreenName(String template) throws Exception {
        return this.mapperRegistry[1].getMappedName(template);
    }

    public String getLayoutName(String template) throws Exception {
        return this.mapperRegistry[2].getMappedName(template);
    }

    public String getNavigationName(String template) throws Exception {
        return this.mapperRegistry[3].getMappedName(template);
    }

    public String getScreenTemplateName(String template) throws Exception {
        return this.mapperRegistry[5].getMappedName(template);
    }

    public String getLayoutTemplateName(String template) throws Exception {
        return this.mapperRegistry[4].getMappedName(template);
    }

    public String getNavigationTemplateName(String template) throws Exception {
        return this.mapperRegistry[6].getMappedName(template);
    }

    public String[] translateTemplatePaths(String[] templatePaths) {
        for (int i = 0; i < templatePaths.length; ++i) {
            templatePaths[i] = TurbineServlet.getRealPath(templatePaths[i]);
        }
        return templatePaths;
    }

    public boolean templateExists(String template, String[] templatePaths) {
        for (int i = 0; i < templatePaths.length; ++i) {
            if (!new File(templatePaths[i], template).exists()) continue;
            return true;
        }
        return false;
    }

    public synchronized void registerTemplateEngineService(TemplateEngineService service) {
        String[] exts = service.getAssociatedFileExtensions();
        for (int i = 0; i < exts.length; ++i) {
            this.templateEngineRegistry.put(exts[i], service);
        }
    }

    public TemplateEngineService getTemplateEngineService(String template) {
        return (TemplateEngineService)this.templateEngineRegistry.get(this.getExtension(template));
    }

    private void registerMapper(int templateKey, Mapper mapper) {
        mapper.init();
        this.mapperRegistry[templateKey] = mapper;
    }

    private void initMapper(Configuration conf) throws InitializationException {
        this.mapperRegistry = new Mapper[7];
        String[] mapperNames = new String[]{PAGE_NAME, SCREEN_NAME, LAYOUT_NAME, NAVIGATION_NAME, LAYOUT_TEMPLATE_NAME, SCREEN_TEMPLATE_NAME, NAVIGATION_TEMPLATE_NAME};
        String[] mapperClasses = new String[]{DirectMapper.class.getName(), ClassMapper.class.getName(), ClassMapper.class.getName(), ClassMapper.class.getName(), LayoutTemplateMapper.class.getName(), ScreenTemplateMapper.class.getName(), DirectTemplateMapper.class.getName()};
        int[] mapperCacheSize = new int[]{0, conf.getInt("screen.cache.size", 50), conf.getInt("layout.cache.size", 10), conf.getInt("navigation.cache.size", 10), conf.getInt("layout.cache.size", 10), conf.getInt("screen.cache.size", 50), conf.getInt("navigation.cache.size", 10)};
        String[] mapperDefaultProperty = new String[]{"default.page", "default.screen", "default.layout", "default.navigation", "default.layout.template", "default.screen.template", "default.navigation.template"};
        char[] mapperSeparator = new char[]{'.', '.', '.', '.', '/', '/', '/'};
        Loader[] mapperLoader = new Loader[]{PageLoader.getInstance(), ScreenLoader.getInstance(), LayoutLoader.getInstance(), NavigationLoader.getInstance(), null, null, null};
        String[] mapperPrefix = new String[]{null, null, null, null, "layouts", "screens", "navigations"};
        for (int i = 0; i < 7; ++i) {
            StringBuffer mapperProperty = new StringBuffer();
            mapperProperty.append("mapper.");
            mapperProperty.append(mapperNames[i]);
            mapperProperty.append(".class");
            String mapperClass = conf.getString(mapperProperty.toString(), mapperClasses[i]);
            log.info((Object)("Using " + mapperClass + " to map " + mapperNames[i] + " elements"));
            Mapper tm = null;
            try {
                tm = (Mapper)TurbineFactory.getInstance(mapperClass);
            }
            catch (TurbineException te) {
                throw new InitializationException(NO_FILE_EXT, (Throwable)((Object)te));
            }
            tm.setUseCache(this.useCache);
            tm.setCacheSize(mapperCacheSize[i]);
            tm.setDefaultProperty(mapperDefaultProperty[i]);
            tm.setSeparator(mapperSeparator[i]);
            if (mapperLoader[i] != null && tm instanceof ClassMapper) {
                ((ClassMapper)tm).setLoader(mapperLoader[i]);
            }
            if (mapperPrefix[i] != null && tm instanceof BaseTemplateMapper) {
                ((BaseTemplateMapper)((Object)tm)).setPrefix(mapperPrefix[i]);
            }
            this.registerMapper(i, tm);
        }
    }
}

