/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import org.apache.turbine.services.intake.IntakeException;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.validator.IntegerValidator;
import org.apache.turbine.services.intake.xmlmodel.XmlField;

public class IntegerField
extends Field {
    public IntegerField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    public void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        this.defaultValue = new Integer(prop);
    }

    public void setEmptyValue(String prop) {
        this.emptyValue = null;
        if (prop == null) {
            return;
        }
        this.emptyValue = new Integer(prop);
    }

    protected Object getSafeEmptyValue() {
        if (this.isMultiValued) {
            return new int[0];
        }
        return null == this.getEmptyValue() ? new Integer(0) : this.getEmptyValue();
    }

    protected String getDefaultValidator() {
        return IntegerValidator.class.getName();
    }

    protected void doSetValue() {
        if (this.isMultiValued) {
            Integer[] inputs = this.parser.getIntObjects(this.getKey());
            int[] values = new int[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                values[i] = inputs[i] == null ? ((Integer)this.getEmptyValue()).intValue() : inputs[i].intValue();
            }
            this.setTestValue(values);
        } else {
            this.setTestValue(this.parser.getIntObject(this.getKey(), (Integer)this.getEmptyValue()));
        }
    }
}

