/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;

class ExecutingJobsManager
implements JobListener {
    HashMap executingJobs = new HashMap();
    int numJobsFired = 0;

    ExecutingJobsManager() {
    }

    public String getName() {
        return this.getClass().getName();
    }

    public int getNumJobsCurrentlyExecuting() {
        HashMap hashMap = this.executingJobs;
        synchronized (hashMap) {
            int n = this.executingJobs.size();
            return n;
        }
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        ++this.numJobsFired;
        HashMap hashMap = this.executingJobs;
        synchronized (hashMap) {
            this.executingJobs.put(context.getTrigger().getFireInstanceId(), context);
        }
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        HashMap hashMap = this.executingJobs;
        synchronized (hashMap) {
            this.executingJobs.remove(context.getTrigger().getFireInstanceId());
        }
    }

    public int getNumJobsFired() {
        return this.numJobsFired;
    }

    public List getExecutingJobs() {
        HashMap hashMap = this.executingJobs;
        synchronized (hashMap) {
            List list = Collections.unmodifiableList(new ArrayList(this.executingJobs.values()));
            return list;
        }
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
    }
}

