/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.turbine;

import java.sql.Connection;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.turbine.AbstractTurbineModelManager;
import org.apache.fulcrum.security.model.turbine.TurbineModelManager;
import org.apache.fulcrum.security.model.turbine.entity.TurbineGroup;
import org.apache.fulcrum.security.model.turbine.entity.TurbinePermission;
import org.apache.fulcrum.security.model.turbine.entity.TurbineRole;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUser;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUserGroupRole;
import org.apache.fulcrum.security.torque.LazyLoadable;
import org.apache.fulcrum.security.torque.om.TurbineRolePermissionPeer;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.torque.security.turbine.TorqueAbstractTurbineTurbineSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public class TorqueTurbineModelManagerImpl
extends AbstractTurbineModelManager
implements TurbineModelManager {
    private static final long serialVersionUID = -306753988209612899L;

    public synchronized void grant(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        boolean roleExists = this.getRoleManager().checkExists(role);
        boolean permissionExists = this.getPermissionManager().checkExists(permission);
        if (roleExists && permissionExists) {
            if (role instanceof TurbineRole) {
                ((TurbineRole)role).addPermission(permission);
            }
            if (permission instanceof TurbinePermission) {
                ((TurbinePermission)permission).addRole(role);
            }
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                ((TorqueAbstractSecurityEntity)role).update((Connection)con);
                ((TorqueAbstractSecurityEntity)permission).update((Connection)con);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (TorqueException e) {
                throw new DataBackendException("grant('" + role.getName() + "', '" + permission.getName() + "') failed", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
            return;
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!permissionExists) {
            throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
        }
    }

    public synchronized void revoke(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        boolean roleExists = this.getRoleManager().checkExists(role);
        boolean permissionExists = this.getPermissionManager().checkExists(permission);
        if (roleExists && permissionExists) {
            if (role instanceof TurbineRole) {
                ((TurbineRole)role).removePermission(permission);
            }
            if (permission instanceof TurbinePermission) {
                ((TurbinePermission)permission).removeRole(role);
            }
            try {
                Criteria criteria = new Criteria();
                criteria.where((Object)TurbineRolePermissionPeer.ROLE_ID, role.getId());
                criteria.where((Object)TurbineRolePermissionPeer.PERMISSION_ID, (Object)((Integer)permission.getId()));
                TurbineRolePermissionPeer.doDelete(criteria);
            }
            catch (TorqueException e) {
                throw new DataBackendException("revoke('" + role.getName() + "', '" + permission.getName() + "') failed", (Throwable)e);
            }
            return;
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!permissionExists) {
            throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
        }
    }

    public synchronized void grant(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        this.handlePrivileges(TurbineModelManager.Privilege.GRANT, user, group, role);
    }

    public synchronized void revoke(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        if (this.checkExists(user, group, role)) {
            this.handlePrivileges(TurbineModelManager.Privilege.REVOKE, user, group, role);
        }
    }

    public void replace(User user, Role oldRole, Role newRole) throws DataBackendException, UnknownEntityException {
        Group group = this.getGlobalGroup();
        if (this.checkExists(user, oldRole, newRole, group)) {
            this.handlePrivileges(TurbineModelManager.Privilege.REPLACE_ROLE, user, group, oldRole, newRole);
        }
    }

    private void addUserGroupRole(User user, Role role, Group group) throws DataBackendException {
        TurbineUserGroupRole new_user_group_role = new TurbineUserGroupRole();
        new_user_group_role.setUser(user);
        new_user_group_role.setGroup(group);
        new_user_group_role.setRole(role);
        ((TurbineUser)user).addUserGroupRole(new_user_group_role);
        if (group instanceof TurbineGroup) {
            if (this.getGroupManager() instanceof LazyLoadable) {
                ((TorqueAbstractTurbineTurbineSecurityEntity)group).addUserGroupRole(new_user_group_role, ((LazyLoadable)this.getGroupManager()).getLazyLoading());
            } else {
                ((TurbineGroup)group).addUserGroupRole(new_user_group_role);
            }
        }
        if (role instanceof TurbineRole) {
            if (this.getRoleManager() instanceof LazyLoadable) {
                ((TorqueAbstractTurbineTurbineSecurityEntity)role).addUserGroupRole(new_user_group_role, ((LazyLoadable)this.getRoleManager()).getLazyLoading());
            } else {
                ((TurbineRole)role).addUserGroupRole(new_user_group_role);
            }
        }
    }

    private void removeUserGroupRole(User user, Role role, Group group) throws DataBackendException, UnknownEntityException {
        boolean ugrFound = false;
        for (TurbineUserGroupRole user_group_role : ((TurbineUser)user).getUserGroupRoleSet()) {
            if (!user_group_role.getUser().equals((Object)user) || !user_group_role.getGroup().equals((Object)group) || !user_group_role.getRole().equals((Object)role)) continue;
            ugrFound = true;
            ((TurbineUser)user).removeUserGroupRole(user_group_role);
            if (group instanceof TurbineGroup) {
                if (this.getGroupManager() instanceof LazyLoadable) {
                    ((TorqueAbstractTurbineTurbineSecurityEntity)group).removeUserGroupRole(user_group_role, ((LazyLoadable)this.getGroupManager()).getLazyLoading());
                } else {
                    ((TurbineGroup)group).removeUserGroupRole(user_group_role);
                }
            }
            if (!(role instanceof TurbineRole)) break;
            if (this.getRoleManager() instanceof LazyLoadable) {
                ((TorqueAbstractTurbineTurbineSecurityEntity)role).removeUserGroupRole(user_group_role, ((LazyLoadable)this.getGroupManager()).getLazyLoading());
                break;
            }
            ((TurbineRole)role).removeUserGroupRole(user_group_role);
            break;
        }
        if (!ugrFound) {
            throw new UnknownEntityException("Could not find User/Group/Role for Role " + role.getName());
        }
    }

    private boolean checkExists(User user, Group group, Role role) throws UnknownEntityException, DataBackendException {
        boolean roleExists = this.getRoleManager().checkExists(role);
        boolean userExists = this.getUserManager().checkExists(user);
        boolean groupExists = this.getGroupManager().checkExists(group);
        if (roleExists && groupExists && userExists) {
            return true;
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
        return false;
    }

    private boolean checkExists(User user, Role oldRole, Role newRole, Group globalGroup) throws UnknownEntityException, DataBackendException {
        boolean userExists = this.getUserManager().checkExists(user);
        boolean oldRoleExists = this.getRoleManager().checkExists(oldRole);
        boolean newRoleExists = this.getRoleManager().checkExists(newRole);
        if (userExists && oldRoleExists && newRoleExists && globalGroup != null) {
            return true;
        }
        if (!oldRoleExists) {
            throw new UnknownEntityException("Unknown role '" + oldRole.getName() + "'");
        }
        if (!newRoleExists) {
            throw new UnknownEntityException("Unknown role '" + newRole.getName() + "'");
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
        return false;
    }

    private void handlePrivileges(TurbineModelManager.Privilege privilege, User user, Group group, Role role, Role newRole) throws DataBackendException, UnknownEntityException {
        String logChars = privilege.toString() + "('" + user.getName() + "', '" + group.getName() + "', '" + role.getName() + "')";
        switch (privilege) {
            case GRANT: {
                this.addUserGroupRole(user, role, group);
                break;
            }
            case REVOKE: {
                this.removeUserGroupRole(user, role, group);
                break;
            }
            case REPLACE_ROLE: {
                this.addUserGroupRole(user, newRole, group);
                this.removeUserGroupRole(user, role, group);
                logChars = TurbineModelManager.Privilege.REPLACE_ROLE.toString() + "('" + user.getName() + "', '" + role.getName() + "', '" + newRole.getName() + "')";
            }
        }
        this.syncPrivilegeWithDatabase(user, logChars);
    }

    private void handlePrivileges(TurbineModelManager.Privilege privilege, User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        this.handlePrivileges(privilege, user, group, role, null);
    }

    private void syncPrivilegeWithDatabase(User user, String logChars) throws DataBackendException {
        TorqueConnection con = null;
        try {
            con = Transaction.begin();
            ((TorqueAbstractSecurityEntity)user).update((Connection)con);
            Transaction.commit((Connection)con);
            con = null;
        }
        catch (TorqueException e) {
            throw new DataBackendException(logChars + " failed", (Throwable)e);
        }
        catch (Exception e) {
            throw new DataBackendException(logChars + " failed", (Throwable)e);
        }
        finally {
            if (con != null) {
                Transaction.safeRollback((Connection)con);
            }
        }
    }
}

