package org.apache.fulcrum.security.torque.om;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.om.mapper.CompositeMapper;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.map.TableMap;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.JdbcTypedValue;



/**
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Fri Jan 03 13:59:32 CET 2025]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to TorqueTurbineUserGroupRolePeer
 */

@SuppressWarnings("unused")
public abstract class BaseTorqueTurbineUserGroupRolePeerImpl
    extends org.apache.torque.util.AbstractPeerImpl<TorqueTurbineUserGroupRole>
{
    /** Serial version */
    private static final long serialVersionUID = 1735909172878L;



    /**
     * Constructor.
     * The recordMapper, tableMap and databaseName fields are correctly
     * initialized.
     */
    public BaseTorqueTurbineUserGroupRolePeerImpl()
    {
        this(new TorqueTurbineUserGroupRoleRecordMapper(),
            TorqueTurbineUserGroupRolePeer.TABLE,
            TorqueTurbineUserGroupRolePeer.DATABASE_NAME);
    }

    /**
     * Constructor providing the objects to be injected as parameters.
     *
     * @param recordMapper a record mapper to map JDBC result sets to objects
     * @param tableMap the default table map
     * @param databaseName the name of the database
     */
    public BaseTorqueTurbineUserGroupRolePeerImpl(
            RecordMapper<TorqueTurbineUserGroupRole> recordMapper, 
            TableMap tableMap,
            String databaseName)
    {
        super(recordMapper, tableMap, databaseName);
    }


    /**
     * Returns a new instance of the Data object class
     */
    public TorqueTurbineUserGroupRole getDbObjectInstance()
    {
        return new TorqueTurbineUserGroupRole();
    }


    /**
     * Method to do updates.  This method is to be used during a transaction,
     * otherwise use the doUpdate(Criteria) method.
     *
     * @param columnValues the values to update plus the primary key
     *        identifying the row to update.
     * @param con the connection to use, not null.
     *
     * @return the number of affected rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doUpdate(ColumnValues columnValues, Connection con)
        throws TorqueException
    {
        Criteria selectCriteria = new Criteria(getDatabaseName());
        correctBooleans(columnValues);

        {
            JdbcTypedValue pkValue
                = columnValues.remove(TorqueTurbineUserGroupRolePeer.USER_ID);
            if (pkValue == null)
            {
                throw new TorqueException(
                        "The value for the primary key column "
                        + "TorqueTurbineUserGroupRolePeer.USER_ID"
                        + " must be set");
            }
            if (pkValue.getSqlExpression() == null)
            {
                selectCriteria.where(
                        TorqueTurbineUserGroupRolePeer.USER_ID,
                        pkValue.getValue());
            }
            else
            {
                selectCriteria.where(
                        TorqueTurbineUserGroupRolePeer.USER_ID,
                        pkValue.getSqlExpression());
            }
        }
        {
            JdbcTypedValue pkValue
                = columnValues.remove(TorqueTurbineUserGroupRolePeer.GROUP_ID);
            if (pkValue == null)
            {
                throw new TorqueException(
                        "The value for the primary key column "
                        + "TorqueTurbineUserGroupRolePeer.GROUP_ID"
                        + " must be set");
            }
            if (pkValue.getSqlExpression() == null)
            {
                selectCriteria.where(
                        TorqueTurbineUserGroupRolePeer.GROUP_ID,
                        pkValue.getValue());
            }
            else
            {
                selectCriteria.where(
                        TorqueTurbineUserGroupRolePeer.GROUP_ID,
                        pkValue.getSqlExpression());
            }
        }
        {
            JdbcTypedValue pkValue
                = columnValues.remove(TorqueTurbineUserGroupRolePeer.ROLE_ID);
            if (pkValue == null)
            {
                throw new TorqueException(
                        "The value for the primary key column "
                        + "TorqueTurbineUserGroupRolePeer.ROLE_ID"
                        + " must be set");
            }
            if (pkValue.getSqlExpression() == null)
            {
                selectCriteria.where(
                        TorqueTurbineUserGroupRolePeer.ROLE_ID,
                        pkValue.getValue());
            }
            else
            {
                selectCriteria.where(
                        TorqueTurbineUserGroupRolePeer.ROLE_ID,
                        pkValue.getSqlExpression());
            }
        }


        int rowCount = doUpdate(selectCriteria, columnValues, con);
        return rowCount;
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     *
     * @param obj the data object to delete in the database, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(TorqueTurbineUserGroupRole obj) throws TorqueException
    {
        int result = doDelete(buildCriteria(obj.getPrimaryKey()));
        obj.setDeleted(true);
        return result;
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     * This method is to be used during a transaction, otherwise use the
     * doDelete(TorqueTurbineUserGroupRole) method.
     *
     * @param obj the data object to delete in the database, not null.
     * @param con the connection to use, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(TorqueTurbineUserGroupRole obj, Connection con)
        throws TorqueException
    {
        int result = doDelete(buildCriteria(obj.getPrimaryKey()), con);
        obj.setDeleted(true);
        return result;
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     *
     * @param objects the data object to delete in the database, not null,
     *        may not contain null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(Collection<TorqueTurbineUserGroupRole> objects)
            throws TorqueException
    {
        int result = doDelete(buildPkCriteria(objects));
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     * This method uses the passed connection to delete the rows;
     * if a transaction is open in the connection, the deletion happens inside
     * this transaction.
     *
     * @param objects the data objects to delete in the database, not null,
     *        may not contain null.
     * @param con the connection to use for deleting, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(
            Collection<TorqueTurbineUserGroupRole> objects,
            Connection con)
        throws TorqueException
    {
        int result = doDelete(buildPkCriteria(objects), con);
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    /** 
     * Build a Criteria object which selects all objects which have a given
     * primary key.
     *
     * @param pk the primary key value to build the criteria from, not null.
     */
    public Criteria buildCriteria(ObjectKey<?> pk)
    {
        Criteria criteria = new Criteria();
        SimpleKey<?>[] keys = (SimpleKey[])pk.getValue();
        criteria.and(TorqueTurbineUserGroupRolePeer.USER_ID, keys[0]);
        criteria.and(TorqueTurbineUserGroupRolePeer.GROUP_ID, keys[1]);
        criteria.and(TorqueTurbineUserGroupRolePeer.ROLE_ID, keys[2]);
        return criteria;
     }

    /** 
     * Build a Criteria object which selects all objects which primary keys
     * are contained in the passed collection.
     *
     * @param pks the primary key values to build the criteria from, not null,
     *        may not contain null.
     */
    public Criteria buildCriteria(Collection<ObjectKey<?>> pks)
    {
        Criteria criteria = new Criteria();
        for (ObjectKey<?> pk : pks)
        {
            SimpleKey<?>[] keys = (SimpleKey[])pk.getValue();
                Criterion c0 = new Criterion(
                    TorqueTurbineUserGroupRolePeer.USER_ID, keys[0], Criteria.EQUAL);
                Criterion c1 = new Criterion(
                    TorqueTurbineUserGroupRolePeer.GROUP_ID, keys[1], Criteria.EQUAL);
                    c0.and(c1);
                Criterion c2 = new Criterion(
                    TorqueTurbineUserGroupRolePeer.ROLE_ID, keys[2], Criteria.EQUAL);
                    c1.and(c2);
            criteria.or(c0);
        }
        return criteria;
     }


    /** 
     * Build a Criteria object which selects all passed objects using their
     * primary key. Objects which do not yet have a primary key are ignored.
     *
     * @param objects the objects to build the criteria from, not null,
     *        may not contain null.
     */
    public Criteria buildPkCriteria(
            Collection<TorqueTurbineUserGroupRole> objects)
    {
        return buildCriteria(objects.stream()
                .map(object -> object.getPrimaryKey())
                .collect(Collectors.toList()));
    }

    /** 
     * Build a Criteria object from the data object for this peer.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public Criteria buildCriteria(TorqueTurbineUserGroupRole obj)
    {
        Criteria criteria = new Criteria(getDatabaseName());
        criteria.and(TorqueTurbineUserGroupRolePeer.USER_ID, obj.getUserId());
        criteria.and(TorqueTurbineUserGroupRolePeer.GROUP_ID, obj.getGroupId());
        criteria.and(TorqueTurbineUserGroupRolePeer.ROLE_ID, obj.getRoleId());
        return criteria;
    }

    /** 
     * Build a Criteria object from the data object for this peer,
     * skipping all binary columns.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public Criteria buildSelectCriteria(TorqueTurbineUserGroupRole obj)
    {
        Criteria criteria = new Criteria(getDatabaseName());
        criteria.and(TorqueTurbineUserGroupRolePeer.USER_ID, obj.getUserId());
        criteria.and(TorqueTurbineUserGroupRolePeer.GROUP_ID, obj.getGroupId());
        criteria.and(TorqueTurbineUserGroupRolePeer.ROLE_ID, obj.getRoleId());
        return criteria;
    }

    /** 
     * Returns the contents of the object as ColumnValues object.
     * Primary key columns which are generated on insertion are not
     * added to the returned object if they still have their initial
     * value. Also, columns which have the useDatabaseDefaultValue
     * flag set to true are also not added to the returned object
     * if they still have their initial value.
     *
     * @throws TorqueException if the table map cannot be retrieved
     *         (should not happen).
     */
    public ColumnValues buildColumnValues(TorqueTurbineUserGroupRole torqueTurbineUserGroupRole)
            throws TorqueException
    {
        ColumnValues columnValues = new ColumnValues();
        columnValues.put(
                TorqueTurbineUserGroupRolePeer.USER_ID,
                new JdbcTypedValue(
                    torqueTurbineUserGroupRole.getUserId(),
                    4));
        columnValues.put(
                TorqueTurbineUserGroupRolePeer.GROUP_ID,
                new JdbcTypedValue(
                    torqueTurbineUserGroupRole.getGroupId(),
                    4));
        columnValues.put(
                TorqueTurbineUserGroupRolePeer.ROLE_ID,
                new JdbcTypedValue(
                    torqueTurbineUserGroupRole.getRoleId(),
                    4));
        return columnValues;
    }

    /**
     * retrieve object using using pk values.
     *
     * @param userId Integer
     * @param groupId Integer
     * @param roleId Integer
     */
    public TorqueTurbineUserGroupRole retrieveByPK(
            Integer userId,
            Integer groupId,
            Integer roleId)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            TorqueTurbineUserGroupRole result = retrieveByPK(
               userId,
               groupId,
               roleId,
               connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * retrieve object using using pk values.
     *
     * @param userId Integer
     * @param groupId Integer
     * @param roleId Integer
     * @param con Connection
     */
    public TorqueTurbineUserGroupRole retrieveByPK(
            Integer userId,
            Integer groupId,
            Integer roleId,
            Connection con) throws TorqueException
    {

        Criteria criteria = new Criteria();
        criteria.and(TorqueTurbineUserGroupRolePeer.USER_ID, userId);
        criteria.and(TorqueTurbineUserGroupRolePeer.GROUP_ID, groupId);
        criteria.and(TorqueTurbineUserGroupRolePeer.ROLE_ID, roleId);
        TorqueTurbineUserGroupRole v = doSelectSingleRecord(criteria, con);
        if (v == null)
        {
            throw new NoRowsException("Failed to select a row.");
        }

        return v;
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TorqueTurbineUserGroupRole retrieveByPK(ObjectKey<?> pk)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            TorqueTurbineUserGroupRole result = retrieveByPK(pk, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TorqueTurbineUserGroupRole retrieveByPK(ObjectKey<?> pk, Connection con)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        Criteria criteria = buildCriteria(pk);
        TorqueTurbineUserGroupRole v = doSelectSingleRecord(criteria, con);
        if (v == null)
        {
            throw new NoRowsException("Failed to select a row.");
        }

        return v;
    }


    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineUserGroupRole> retrieveByObjectKeys(Collection<ObjectKey<?>> pks)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueTurbineUserGroupRole> result = retrieveByObjectKeys(pks, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     * @param dbcon the connection to use
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineUserGroupRole> retrieveByObjectKeys(
                Collection<ObjectKey<?>> pks,
                Connection dbcon)
            throws TorqueException
    {
        if (pks == null || pks.size() == 0)
        {
            return new ArrayList<TorqueTurbineUserGroupRole>();
        }
        Criteria criteria = buildCriteria(pks);
        List<TorqueTurbineUserGroupRole> result = doSelect(criteria, dbcon);
        return result;
    }


    /**
     * Selects a collection of dbObjectClassName objects pre-filled with their
     * TorqueTurbineUser objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineUserGroupRole> doSelectJoinTorqueTurbineUser(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueTurbineUserGroupRole> result
                    = TorqueTurbineUserGroupRolePeer.doSelectJoinTorqueTurbineUser(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Selects a collection of TorqueTurbineUserGroupRole objects pre-filled with their
     * TorqueTurbineUser objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineUserGroupRole> doSelectJoinTorqueTurbineUser(
            Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        addSelectColumns(criteria);
        org.apache.fulcrum.security.torque.om.TorqueTurbineUserPeer.addSelectColumns(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(
                new TorqueTurbineUserGroupRoleRecordMapper(),
                0);
        compositeMapper.addMapper(
                new TorqueTurbineUserRecordMapper(),
                TorqueTurbineUserGroupRolePeer.numColumns);
        criteria.addJoin(TorqueTurbineUserGroupRolePeer.USER_ID,
            org.apache.fulcrum.security.torque.om.TorqueTurbineUserPeer.USER_ID);

        correctBooleans(criteria);

        List<TorqueTurbineUserGroupRole> result = new ArrayList<TorqueTurbineUserGroupRole>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TorqueTurbineUserGroupRole obj1 = (TorqueTurbineUserGroupRole) rawResultRow.get(0);
            TorqueTurbineUser obj2 = (TorqueTurbineUser) rawResultRow.get(1);

            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                TorqueTurbineUserGroupRole temp_obj1 = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueTurbineUser temp_obj2 = temp_obj1.getTorqueTurbineUser();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTorqueTurbineUserGroupRole(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTorqueTurbineUserGroupRoles();
                obj2.addTorqueTurbineUserGroupRole(obj1);
            }
            result.add(obj1);
        }
        return result;
    }
    /**
     * Selects a collection of dbObjectClassName objects pre-filled with their
     * TorqueTurbineGroup objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineUserGroupRole> doSelectJoinTorqueTurbineGroup(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueTurbineUserGroupRole> result
                    = TorqueTurbineUserGroupRolePeer.doSelectJoinTorqueTurbineGroup(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Selects a collection of TorqueTurbineUserGroupRole objects pre-filled with their
     * TorqueTurbineGroup objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineUserGroupRole> doSelectJoinTorqueTurbineGroup(
            Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        addSelectColumns(criteria);
        org.apache.fulcrum.security.torque.om.TorqueTurbineGroupPeer.addSelectColumns(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(
                new TorqueTurbineUserGroupRoleRecordMapper(),
                0);
        compositeMapper.addMapper(
                new TorqueTurbineGroupRecordMapper(),
                TorqueTurbineUserGroupRolePeer.numColumns);
        criteria.addJoin(TorqueTurbineUserGroupRolePeer.GROUP_ID,
            org.apache.fulcrum.security.torque.om.TorqueTurbineGroupPeer.GROUP_ID);

        correctBooleans(criteria);

        List<TorqueTurbineUserGroupRole> result = new ArrayList<TorqueTurbineUserGroupRole>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TorqueTurbineUserGroupRole obj1 = (TorqueTurbineUserGroupRole) rawResultRow.get(0);
            TorqueTurbineGroup obj2 = (TorqueTurbineGroup) rawResultRow.get(1);

            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                TorqueTurbineUserGroupRole temp_obj1 = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueTurbineGroup temp_obj2 = temp_obj1.getTorqueTurbineGroup();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTorqueTurbineUserGroupRole(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTorqueTurbineUserGroupRoles();
                obj2.addTorqueTurbineUserGroupRole(obj1);
            }
            result.add(obj1);
        }
        return result;
    }
    /**
     * Selects a collection of dbObjectClassName objects pre-filled with their
     * TorqueTurbineRole objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineUserGroupRole> doSelectJoinTorqueTurbineRole(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueTurbineUserGroupRole> result
                    = TorqueTurbineUserGroupRolePeer.doSelectJoinTorqueTurbineRole(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Selects a collection of TorqueTurbineUserGroupRole objects pre-filled with their
     * TorqueTurbineRole objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineUserGroupRole> doSelectJoinTorqueTurbineRole(
            Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        addSelectColumns(criteria);
        org.apache.fulcrum.security.torque.om.TorqueTurbineRolePeer.addSelectColumns(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(
                new TorqueTurbineUserGroupRoleRecordMapper(),
                0);
        compositeMapper.addMapper(
                new TorqueTurbineRoleRecordMapper(),
                TorqueTurbineUserGroupRolePeer.numColumns);
        criteria.addJoin(TorqueTurbineUserGroupRolePeer.ROLE_ID,
            org.apache.fulcrum.security.torque.om.TorqueTurbineRolePeer.ROLE_ID);

        correctBooleans(criteria);

        List<TorqueTurbineUserGroupRole> result = new ArrayList<TorqueTurbineUserGroupRole>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TorqueTurbineUserGroupRole obj1 = (TorqueTurbineUserGroupRole) rawResultRow.get(0);
            TorqueTurbineRole obj2 = (TorqueTurbineRole) rawResultRow.get(1);

            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                TorqueTurbineUserGroupRole temp_obj1 = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueTurbineRole temp_obj2 = temp_obj1.getTorqueTurbineRole();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTorqueTurbineUserGroupRole(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTorqueTurbineUserGroupRoles();
                obj2.addTorqueTurbineUserGroupRole(obj1);
            }
            result.add(obj1);
        }
        return result;
    }

    /**
     * selects a collection of TorqueTurbineUserGroupRole objects pre-filled with
     * all related objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TorqueTurbineUserGroupRolePeerImpl.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected List<TorqueTurbineUserGroupRole> doSelectJoinAllExceptTorqueTurbineUser(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueTurbineUserGroupRole> result
                    = TorqueTurbineUserGroupRolePeer.doSelectJoinAllExceptTorqueTurbineUser(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * selects a collection of TorqueTurbineUserGroupRole objects pre-filled with
     * related objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TorqueTurbineUserGroupRolePeerImpl.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected List<TorqueTurbineUserGroupRole> doSelectJoinAllExceptTorqueTurbineUser(Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(new TorqueTurbineUserGroupRoleRecordMapper(), 0);
        TorqueTurbineUserGroupRolePeer.addSelectColumns(criteria);
        int offset = TorqueTurbineUserGroupRolePeer.numColumns;
 
        org.apache.fulcrum.security.torque.om.TorqueTurbineGroupPeer.addSelectColumns(criteria);
        criteria.addJoin(TorqueTurbineUserGroupRolePeer.GROUP_ID, org.apache.fulcrum.security.torque.om.TorqueTurbineGroupPeer.GROUP_ID);
        compositeMapper.addMapper(new TorqueTurbineGroupRecordMapper(), offset);
        offset = offset + org.apache.fulcrum.security.torque.om.TorqueTurbineGroupPeer.numColumns;
 
        org.apache.fulcrum.security.torque.om.TorqueTurbineRolePeer.addSelectColumns(criteria);
        criteria.addJoin(TorqueTurbineUserGroupRolePeer.ROLE_ID, org.apache.fulcrum.security.torque.om.TorqueTurbineRolePeer.ROLE_ID);
        compositeMapper.addMapper(new TorqueTurbineRoleRecordMapper(), offset);
        offset = offset + org.apache.fulcrum.security.torque.om.TorqueTurbineRolePeer.numColumns;

        correctBooleans(criteria);

        List<TorqueTurbineUserGroupRole> result = new ArrayList<TorqueTurbineUserGroupRole>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TorqueTurbineUserGroupRole torqueTurbineUserGroupRole = (TorqueTurbineUserGroupRole) rawResultRow.get(0);

            org.apache.fulcrum.security.torque.om.TorqueTurbineGroup obj1 = (org.apache.fulcrum.security.torque.om.TorqueTurbineGroup) rawResultRow.get(1);
            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                org.apache.fulcrum.security.torque.om.TorqueTurbineUserGroupRole temp_torqueTurbineUserGroupRole = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueTurbineGroup temp_obj1 = temp_torqueTurbineUserGroupRole.getTorqueTurbineGroup();
                if (temp_obj1.getPrimaryKey().equals(obj1.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj1.addTorqueTurbineUserGroupRole(torqueTurbineUserGroupRole);
                    break;
                }
            }
            if (newObject)
            {
                obj1.initTorqueTurbineUserGroupRoles();
                obj1.addTorqueTurbineUserGroupRole(torqueTurbineUserGroupRole);
            }

            org.apache.fulcrum.security.torque.om.TorqueTurbineRole obj2 = (org.apache.fulcrum.security.torque.om.TorqueTurbineRole) rawResultRow.get(2);
            newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                org.apache.fulcrum.security.torque.om.TorqueTurbineUserGroupRole temp_torqueTurbineUserGroupRole = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueTurbineRole temp_obj2 = temp_torqueTurbineUserGroupRole.getTorqueTurbineRole();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTorqueTurbineUserGroupRole(torqueTurbineUserGroupRole);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTorqueTurbineUserGroupRoles();
                obj2.addTorqueTurbineUserGroupRole(torqueTurbineUserGroupRole);
            }
            result.add(torqueTurbineUserGroupRole);
        }
        return result;
    }
    /**
     * selects a collection of TorqueTurbineUserGroupRole objects pre-filled with
     * all related objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TorqueTurbineUserGroupRolePeerImpl.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected List<TorqueTurbineUserGroupRole> doSelectJoinAllExceptTorqueTurbineGroup(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueTurbineUserGroupRole> result
                    = TorqueTurbineUserGroupRolePeer.doSelectJoinAllExceptTorqueTurbineGroup(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * selects a collection of TorqueTurbineUserGroupRole objects pre-filled with
     * related objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TorqueTurbineUserGroupRolePeerImpl.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected List<TorqueTurbineUserGroupRole> doSelectJoinAllExceptTorqueTurbineGroup(Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(new TorqueTurbineUserGroupRoleRecordMapper(), 0);
        TorqueTurbineUserGroupRolePeer.addSelectColumns(criteria);
        int offset = TorqueTurbineUserGroupRolePeer.numColumns;
 
        org.apache.fulcrum.security.torque.om.TorqueTurbineUserPeer.addSelectColumns(criteria);
        criteria.addJoin(TorqueTurbineUserGroupRolePeer.USER_ID, org.apache.fulcrum.security.torque.om.TorqueTurbineUserPeer.USER_ID);
        compositeMapper.addMapper(new TorqueTurbineUserRecordMapper(), offset);
        offset = offset + org.apache.fulcrum.security.torque.om.TorqueTurbineUserPeer.numColumns;
 
        org.apache.fulcrum.security.torque.om.TorqueTurbineRolePeer.addSelectColumns(criteria);
        criteria.addJoin(TorqueTurbineUserGroupRolePeer.ROLE_ID, org.apache.fulcrum.security.torque.om.TorqueTurbineRolePeer.ROLE_ID);
        compositeMapper.addMapper(new TorqueTurbineRoleRecordMapper(), offset);
        offset = offset + org.apache.fulcrum.security.torque.om.TorqueTurbineRolePeer.numColumns;

        correctBooleans(criteria);

        List<TorqueTurbineUserGroupRole> result = new ArrayList<TorqueTurbineUserGroupRole>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TorqueTurbineUserGroupRole torqueTurbineUserGroupRole = (TorqueTurbineUserGroupRole) rawResultRow.get(0);

            org.apache.fulcrum.security.torque.om.TorqueTurbineUser obj1 = (org.apache.fulcrum.security.torque.om.TorqueTurbineUser) rawResultRow.get(1);
            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                org.apache.fulcrum.security.torque.om.TorqueTurbineUserGroupRole temp_torqueTurbineUserGroupRole = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueTurbineUser temp_obj1 = temp_torqueTurbineUserGroupRole.getTorqueTurbineUser();
                if (temp_obj1.getPrimaryKey().equals(obj1.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj1.addTorqueTurbineUserGroupRole(torqueTurbineUserGroupRole);
                    break;
                }
            }
            if (newObject)
            {
                obj1.initTorqueTurbineUserGroupRoles();
                obj1.addTorqueTurbineUserGroupRole(torqueTurbineUserGroupRole);
            }

            org.apache.fulcrum.security.torque.om.TorqueTurbineRole obj2 = (org.apache.fulcrum.security.torque.om.TorqueTurbineRole) rawResultRow.get(2);
            newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                org.apache.fulcrum.security.torque.om.TorqueTurbineUserGroupRole temp_torqueTurbineUserGroupRole = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueTurbineRole temp_obj2 = temp_torqueTurbineUserGroupRole.getTorqueTurbineRole();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTorqueTurbineUserGroupRole(torqueTurbineUserGroupRole);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTorqueTurbineUserGroupRoles();
                obj2.addTorqueTurbineUserGroupRole(torqueTurbineUserGroupRole);
            }
            result.add(torqueTurbineUserGroupRole);
        }
        return result;
    }
    /**
     * selects a collection of TorqueTurbineUserGroupRole objects pre-filled with
     * all related objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TorqueTurbineUserGroupRolePeerImpl.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected List<TorqueTurbineUserGroupRole> doSelectJoinAllExceptTorqueTurbineRole(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueTurbineUserGroupRole> result
                    = TorqueTurbineUserGroupRolePeer.doSelectJoinAllExceptTorqueTurbineRole(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * selects a collection of TorqueTurbineUserGroupRole objects pre-filled with
     * related objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TorqueTurbineUserGroupRolePeerImpl.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected List<TorqueTurbineUserGroupRole> doSelectJoinAllExceptTorqueTurbineRole(Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(new TorqueTurbineUserGroupRoleRecordMapper(), 0);
        TorqueTurbineUserGroupRolePeer.addSelectColumns(criteria);
        int offset = TorqueTurbineUserGroupRolePeer.numColumns;
 
        org.apache.fulcrum.security.torque.om.TorqueTurbineUserPeer.addSelectColumns(criteria);
        criteria.addJoin(TorqueTurbineUserGroupRolePeer.USER_ID, org.apache.fulcrum.security.torque.om.TorqueTurbineUserPeer.USER_ID);
        compositeMapper.addMapper(new TorqueTurbineUserRecordMapper(), offset);
        offset = offset + org.apache.fulcrum.security.torque.om.TorqueTurbineUserPeer.numColumns;
 
        org.apache.fulcrum.security.torque.om.TorqueTurbineGroupPeer.addSelectColumns(criteria);
        criteria.addJoin(TorqueTurbineUserGroupRolePeer.GROUP_ID, org.apache.fulcrum.security.torque.om.TorqueTurbineGroupPeer.GROUP_ID);
        compositeMapper.addMapper(new TorqueTurbineGroupRecordMapper(), offset);
        offset = offset + org.apache.fulcrum.security.torque.om.TorqueTurbineGroupPeer.numColumns;

        correctBooleans(criteria);

        List<TorqueTurbineUserGroupRole> result = new ArrayList<TorqueTurbineUserGroupRole>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TorqueTurbineUserGroupRole torqueTurbineUserGroupRole = (TorqueTurbineUserGroupRole) rawResultRow.get(0);

            org.apache.fulcrum.security.torque.om.TorqueTurbineUser obj1 = (org.apache.fulcrum.security.torque.om.TorqueTurbineUser) rawResultRow.get(1);
            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                org.apache.fulcrum.security.torque.om.TorqueTurbineUserGroupRole temp_torqueTurbineUserGroupRole = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueTurbineUser temp_obj1 = temp_torqueTurbineUserGroupRole.getTorqueTurbineUser();
                if (temp_obj1.getPrimaryKey().equals(obj1.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj1.addTorqueTurbineUserGroupRole(torqueTurbineUserGroupRole);
                    break;
                }
            }
            if (newObject)
            {
                obj1.initTorqueTurbineUserGroupRoles();
                obj1.addTorqueTurbineUserGroupRole(torqueTurbineUserGroupRole);
            }

            org.apache.fulcrum.security.torque.om.TorqueTurbineGroup obj2 = (org.apache.fulcrum.security.torque.om.TorqueTurbineGroup) rawResultRow.get(2);
            newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                org.apache.fulcrum.security.torque.om.TorqueTurbineUserGroupRole temp_torqueTurbineUserGroupRole = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueTurbineGroup temp_obj2 = temp_torqueTurbineUserGroupRole.getTorqueTurbineGroup();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTorqueTurbineUserGroupRole(torqueTurbineUserGroupRole);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTorqueTurbineUserGroupRoles();
                obj2.addTorqueTurbineUserGroupRole(torqueTurbineUserGroupRole);
            }
            result.add(torqueTurbineUserGroupRole);
        }
        return result;
    }



}
