/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import com.google.common.base.Strings;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.codec.EncodingException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.encryption.OriginatorKeyInfo;
import org.opensaml.xmlsec.encryption.RecipientKeyInfo;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;

public class BasicKeyInfoGeneratorFactory
implements KeyInfoGeneratorFactory {
    @Nonnull
    private static final Map<Class<? extends KeyInfo>, QName> CLASS_TO_NAME = new HashMap<Class<? extends KeyInfo>, QName>();
    @Nonnull
    private final BasicOptions options = this.newOptions();

    @Nonnull
    public Class<? extends Credential> getCredentialType() {
        return Credential.class;
    }

    public boolean handles(@Nonnull Credential credential) {
        return true;
    }

    @Nonnull
    public KeyInfoGenerator newInstance() {
        return this.newInstance(null);
    }

    @Nonnull
    public KeyInfoGenerator newInstance(@Nullable Class<? extends KeyInfo> type) {
        return new BasicKeyInfoGenerator(this.options.clone(), type);
    }

    public boolean emitEntityIDAsKeyName() {
        return this.options.emitEntityIDAsKeyName;
    }

    public void setEmitEntityIDAsKeyName(boolean newValue) {
        this.options.emitEntityIDAsKeyName = newValue;
    }

    public boolean emitKeyNames() {
        return this.options.emitKeyNames;
    }

    public void setEmitKeyNames(boolean newValue) {
        this.options.emitKeyNames = newValue;
    }

    public boolean emitPublicKeyValue() {
        return this.options.emitPublicKeyValue;
    }

    public void setEmitPublicKeyValue(boolean newValue) {
        this.options.emitPublicKeyValue = newValue;
    }

    public boolean emitPublicDEREncodedKeyValue() {
        return this.options.emitPublicDEREncodedKeyValue;
    }

    public void setEmitPublicDEREncodedKeyValue(boolean newValue) {
        this.options.emitPublicDEREncodedKeyValue = newValue;
    }

    @Nonnull
    protected BasicOptions newOptions() {
        return new BasicOptions();
    }

    @Nonnull
    protected BasicOptions getOptions() {
        return this.options;
    }

    static {
        CLASS_TO_NAME.put(KeyInfo.class, KeyInfo.DEFAULT_ELEMENT_NAME);
        CLASS_TO_NAME.put(OriginatorKeyInfo.class, OriginatorKeyInfo.DEFAULT_ELEMENT_NAME);
        CLASS_TO_NAME.put(RecipientKeyInfo.class, RecipientKeyInfo.DEFAULT_ELEMENT_NAME);
    }

    protected class BasicOptions
    implements Cloneable {
        private boolean emitKeyNames;
        private boolean emitEntityIDAsKeyName;
        private boolean emitPublicKeyValue;
        private boolean emitPublicDEREncodedKeyValue;

        protected BasicOptions() {
        }

        protected BasicOptions clone() {
            try {
                return (BasicOptions)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public class BasicKeyInfoGenerator
    implements KeyInfoGenerator {
        @Nonnull
        private final BasicOptions options;
        @Nonnull
        private final Class<? extends KeyInfo> keyInfoType;
        @Nonnull
        private final XMLObjectBuilderFactory builderFactory;

        protected BasicKeyInfoGenerator(@Nullable BasicOptions newOptions, Class<? extends KeyInfo> type) {
            this.options = newOptions;
            this.keyInfoType = type != null ? type : KeyInfo.class;
            this.builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        }

        @Nullable
        public KeyInfo generate(@Nullable Credential credential) throws SecurityException {
            if (credential == null) {
                return null;
            }
            KeyInfo keyInfo = this.buildKeyInfo();
            this.processKeyNames(keyInfo, credential);
            this.processEntityID(keyInfo, credential);
            this.processPublicKey(keyInfo, credential);
            List children = keyInfo.getOrderedChildren();
            if (children != null && children.size() > 0) {
                return keyInfo;
            }
            return null;
        }

        @Nonnull
        protected KeyInfo buildKeyInfo() throws SecurityException {
            QName elementName = this.classToElementName(this.keyInfoType);
            if (elementName == null) {
                throw new SecurityException("KeyInfo type not mapped to an element QName: " + this.keyInfoType.getClass().getName());
            }
            XMLObject xmlObject = this.builderFactory.ensureBuilder(elementName).buildObject(elementName);
            return (KeyInfo)KeyInfo.class.cast(xmlObject);
        }

        @Nullable
        protected QName classToElementName(@Nonnull Class<? extends KeyInfo> type) {
            return CLASS_TO_NAME.get(type);
        }

        protected void processKeyNames(@Nonnull KeyInfo keyInfo, @Nonnull Credential credential) {
            if (this.options.emitKeyNames) {
                for (String keyNameValue : credential.getKeyNames()) {
                    if (Strings.isNullOrEmpty((String)keyNameValue)) continue;
                    KeyInfoSupport.addKeyName((KeyInfo)keyInfo, (String)keyNameValue);
                }
            }
        }

        protected void processEntityID(@Nonnull KeyInfo keyInfo, @Nonnull Credential credential) {
            String keyNameValue;
            if (this.options.emitEntityIDAsKeyName && !Strings.isNullOrEmpty((String)(keyNameValue = credential.getEntityId()))) {
                KeyInfoSupport.addKeyName((KeyInfo)keyInfo, (String)keyNameValue);
            }
        }

        protected void processPublicKey(@Nonnull KeyInfo keyInfo, @Nonnull Credential credential) throws SecurityException {
            PublicKey key = credential.getPublicKey();
            if (key != null) {
                if (this.options.emitPublicKeyValue) {
                    try {
                        KeyInfoSupport.addPublicKey((KeyInfo)keyInfo, (PublicKey)key);
                    }
                    catch (EncodingException e) {
                        throw new SecurityException("Can't add public key to key info", (Exception)((Object)e));
                    }
                }
                if (this.options.emitPublicDEREncodedKeyValue) {
                    try {
                        KeyInfoSupport.addDEREncodedPublicKey((KeyInfo)keyInfo, (PublicKey)key);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new SecurityException("Can't DER-encode key, unsupported key algorithm", (Exception)e);
                    }
                    catch (InvalidKeySpecException e) {
                        throw new SecurityException("Can't DER-encode key, invalid key specification", (Exception)e);
                    }
                }
            }
        }
    }
}

