/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.com.google.protobuf;

import org.sparkproject.com.google.protobuf.Android;
import org.sparkproject.com.google.protobuf.CheckReturnValue;
import org.sparkproject.com.google.protobuf.NewInstanceSchema;
import org.sparkproject.com.google.protobuf.NewInstanceSchemaLite;

@CheckReturnValue
final class NewInstanceSchemas {
    private static final NewInstanceSchema FULL_SCHEMA = NewInstanceSchemas.loadSchemaForFullRuntime();
    private static final NewInstanceSchema LITE_SCHEMA = new NewInstanceSchemaLite();

    static NewInstanceSchema full() {
        return FULL_SCHEMA;
    }

    static NewInstanceSchema lite() {
        return LITE_SCHEMA;
    }

    private static NewInstanceSchema loadSchemaForFullRuntime() {
        if (Android.assumeLiteRuntime) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("org.sparkproject.com.google.protobuf.NewInstanceSchemaFull");
            return (NewInstanceSchema)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private NewInstanceSchemas() {
    }
}

