/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Optional;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.diff.DiffRequest;
import org.apache.sling.feature.diff.FeatureDiff;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.apache.sling.feature.maven.mojos.FeatureSelectionConfig;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;

@Mojo(name="features-diff", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public final class FeaturesDiffMojo
extends AbstractIncludingFeatureMojo {
    @Parameter
    private FeatureSelectionConfig selection;
    @Parameter(defaultValue="${project.build.directory}/features-diff", readonly=true)
    private File mainOutputDir;
    @Parameter(defaultValue="(,${project.version})")
    protected String comparisonVersion;
    @Component
    protected RepositorySystem repoSystem;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Retrieving Feature files...");
        Collection<Feature> features = this.getSelectedFeatures(this.selection).values();
        if (features.isEmpty()) {
            this.getLog().debug((CharSequence)"There are no assciated Feature files to current project, plugin execution will be interrupted");
            return;
        }
        if (!this.mainOutputDir.exists()) {
            this.mainOutputDir.mkdirs();
        }
        this.getLog().debug((CharSequence)"Starting Feature(s) analysis...");
        for (Feature feature : features) {
            this.onFeature(feature);
        }
    }

    private void onFeature(Feature current) throws MojoExecutionException, MojoFailureException {
        Feature previous = this.getPreviousFeature(current);
        if (previous == null) {
            this.getLog().info((CharSequence)("There is no previous verion available of " + String.valueOf(current) + " model"));
            return;
        }
        this.getLog().info((CharSequence)("Comparing current " + String.valueOf(current) + " to previous " + String.valueOf(previous)));
        Feature featureDiff = FeatureDiff.compareFeatures((DiffRequest)new DiffRequest().setPrevious(previous).setCurrent(current));
        File outputDiffFile = new File(this.mainOutputDir, featureDiff.getId().getClassifier().concat(".json"));
        this.getLog().info((CharSequence)("Rendering differences to file " + String.valueOf(outputDiffFile)));
        try (FileWriter writer = new FileWriter(outputDiffFile);){
            FeatureJSONWriter.write((Writer)writer, (Feature)featureDiff);
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred while serializing Feature diff to " + String.valueOf(outputDiffFile), (Exception)e);
        }
        this.projectHelper.attachArtifact(this.project, "slingosgifeature", featureDiff.getId().getClassifier(), outputDiffFile);
    }

    private Feature getPreviousFeature(Feature current) throws MojoExecutionException, MojoFailureException {
        Feature feature;
        VersionRange range;
        try {
            range = VersionRange.createFromVersionSpec((String)this.comparisonVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoFailureException("Invalid comparison version: " + e.getMessage());
        }
        DefaultArtifact previousArtifact = new DefaultArtifact(current.getId().getGroupId(), current.getId().getArtifactId(), current.getId().getType(), current.getId().getClassifier(), this.comparisonVersion);
        try {
            if (!range.isSelectedVersionKnown(RepositoryUtils.toArtifact((Artifact)previousArtifact))) {
                this.getLog().debug((CharSequence)("Searching for versions in range: " + this.comparisonVersion));
                VersionRangeRequest vrr = new VersionRangeRequest((Artifact)previousArtifact, this.project.getRemoteProjectRepositories(), null);
                VersionRangeResult vrResult = this.repoSystem.resolveVersionRange(this.mavenSession.getRepositorySession(), vrr);
                Optional<Version> version = vrResult.getVersions().stream().filter(v -> !ArtifactUtils.isSnapshot((String)v.toString())).reduce((first, second) -> second);
                previousArtifact.setVersion((String)version.map(Version::toString).orElse(null));
            }
        }
        catch (OverConstrainedVersionException ocve) {
            throw new MojoFailureException("Invalid comparison version: " + ocve.getMessage());
        }
        catch (VersionRangeResolutionException e) {
            throw new MojoExecutionException("Error determining previous version: " + e.getMessage(), (Exception)((Object)e));
        }
        if (previousArtifact.getVersion() == null) {
            this.getLog().info((CharSequence)("Unable to find a previous version of the " + String.valueOf(current) + " Feature in the repository"));
            return null;
        }
        File featureFile = null;
        try {
            ArtifactRequest artifactRequest = new ArtifactRequest((Artifact)previousArtifact, this.project.getRemoteProjectRepositories(), null);
            ArtifactResult artifactResult = this.repoSystem.resolveArtifact(this.mavenSession.getRepositorySession(), artifactRequest);
            featureFile = artifactResult.getArtifact().getFile();
        }
        catch (ArtifactResolutionException e) {
            this.getLog().warn((CharSequence)("Artifact " + String.valueOf(previousArtifact) + " cannot be resolved : " + e.getMessage()), (Throwable)e);
        }
        if (featureFile == null || !featureFile.exists()) {
            return null;
        }
        FileReader reader = new FileReader(featureFile);
        try {
            feature = FeatureJSONReader.read((Reader)reader, (String)featureFile.getAbsolutePath());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException("An error occurred while reading the " + String.valueOf(featureFile) + " Feature file:", (Exception)e);
            }
        }
        reader.close();
        return feature;
    }
}

