/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.asynchttpclient.v2;

import io.netty.handler.codec.http.HttpHeaders;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.asynchttpclient.v2.AsyncHandlerWrapper;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.Request;
import org.asynchttpclient.uri.Uri;

public class ExecuteInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        Request httpRequest = (Request)allArguments[0];
        Uri requestUri = httpRequest.getUri();
        AbstractSpan span = ContextManager.createExitSpan((String)("AsyncHttpClient" + requestUri.getPath()), (String)(requestUri.getHost() + ":" + requestUri.getPort()));
        allArguments[1] = new AsyncHandlerWrapper((AsyncHandler)allArguments[1], span);
        ContextCarrier contextCarrier = new ContextCarrier();
        ContextManager.inject((ContextCarrier)contextCarrier);
        span.setComponent((Component)ComponentsDefine.ASYNC_HTTP_CLIENT);
        Tags.HTTP.METHOD.set(span, httpRequest.getMethod());
        Tags.URL.set(span, httpRequest.getUrl());
        SpanLayer.asHttp((AbstractSpan)span);
        span.prepareForAsync();
        HttpHeaders headers = httpRequest.getHeaders();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            headers.set(next.getHeadKey(), (Object)next.getHeadValue());
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
        ContextManager.activeSpan().asyncFinish();
    }
}

