/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.util;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import org.apache.skywalking.apm.util.ConfigDesc;
import org.apache.skywalking.apm.util.Length;
import org.apache.skywalking.apm.util.StringUtil;

public class ConfigInitializer {
    public static void initialize(Properties properties, Class<?> rootConfigType) throws IllegalAccessException {
        ConfigInitializer.initNextLevel(properties, rootConfigType, new ConfigDesc());
    }

    private static void initNextLevel(Properties properties, Class<?> recentConfigType, ConfigDesc parentDesc) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : recentConfigType.getFields()) {
            Object convertedValue;
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
            String configKey = (parentDesc + "." + field.getName()).toLowerCase();
            Class<?> type = field.getType();
            if (Map.class.isAssignableFrom(type)) {
                ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                Type[] argumentTypes = genericType.getActualTypeArguments();
                Type keyType = argumentTypes[0];
                Type valueType = argumentTypes[1];
                if (properties.containsKey(configKey + "[]")) {
                    Map currentValue = (Map)field.get(null);
                    if (currentValue == null || currentValue.isEmpty()) continue;
                    field.set(null, ConfigInitializer.initEmptyMap(type));
                    continue;
                }
                Map map = ConfigInitializer.readMapType(type, configKey, properties, keyType, valueType);
                if (map.size() == 0) continue;
                field.set(null, map);
                continue;
            }
            if (!properties.containsKey(configKey)) continue;
            String propertyValue = properties.getProperty(configKey, "");
            if (Collection.class.isAssignableFrom(type)) {
                ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                Type argumentType = genericType.getActualTypeArguments()[0];
                Collection<Object> collection = ConfigInitializer.convertToCollection(argumentType, type, propertyValue);
                field.set(null, collection);
                continue;
            }
            Length lengthDefine = field.getAnnotation(Length.class);
            if (lengthDefine != null) {
                int lengthLimited = lengthDefine.value();
                String lengthKey = String.format("%s#length", configKey);
                if (properties.containsKey(lengthKey)) {
                    try {
                        lengthLimited = Integer.valueOf(properties.getProperty(lengthKey));
                    }
                    catch (NumberFormatException ex) {
                        System.err.printf("The length config (%s=%s) is invalid. The value can not be cast to number.", lengthKey, properties.getProperty(lengthKey));
                    }
                }
                if (propertyValue.length() > lengthLimited) {
                    propertyValue = StringUtil.cut(propertyValue, lengthLimited);
                    System.err.printf("The config value will be truncated , because the length max than %d : %s -> %s%n", lengthDefine.value(), configKey, propertyValue);
                }
            }
            if ((convertedValue = ConfigInitializer.convertToTypicalType(type, propertyValue)) == null) continue;
            field.set(null, convertedValue);
        }
        for (AnnotatedElement annotatedElement : recentConfigType.getClasses()) {
            parentDesc.append(((Class)annotatedElement).getSimpleName());
            ConfigInitializer.initNextLevel(properties, annotatedElement, parentDesc);
            parentDesc.removeLastDesc();
        }
    }

    private static Collection<Object> convertToCollection(Type argumentType, Class<?> type, String propertyValue) {
        AbstractCollection collection;
        if (type.equals(Set.class) || type.equals(HashSet.class)) {
            collection = new HashSet<Object>();
        } else if (type.equals(TreeSet.class)) {
            collection = new TreeSet();
        } else if (type.equals(List.class) || type.equals(LinkedList.class)) {
            collection = new LinkedList();
        } else if (type.equals(ArrayList.class)) {
            collection = new ArrayList();
        } else {
            throw new UnsupportedOperationException("Config parameter type support Set,HashSet,TreeSet,List,LinkedList,ArrayList");
        }
        if (StringUtil.isBlank(propertyValue)) {
            return collection;
        }
        Arrays.stream(propertyValue.split(",")).map(v -> ConfigInitializer.convertToTypicalType(argumentType, v)).forEach(collection::add);
        return collection;
    }

    private static Object convertToTypicalType(Type type, String value) {
        Class clazz;
        if (StringUtil.isBlank(value)) {
            return null;
        }
        Object result = null;
        if (String.class.equals((Object)type)) {
            result = value;
        } else if (Integer.TYPE.equals(type) || Integer.class.equals((Object)type)) {
            result = Integer.valueOf(value);
        } else if (Long.TYPE.equals(type) || Long.class.equals((Object)type)) {
            result = Long.valueOf(value);
        } else if (Boolean.TYPE.equals(type) || Boolean.class.equals((Object)type)) {
            result = Boolean.valueOf(value);
        } else if (Float.TYPE.equals(type) || Float.class.equals((Object)type)) {
            result = Float.valueOf(value);
        } else if (Double.TYPE.equals(type) || Double.class.equals((Object)type)) {
            result = Double.valueOf(value);
        } else if (type instanceof Class && (clazz = (Class)type).isEnum()) {
            result = Enum.valueOf((Class)type, value.toUpperCase());
        }
        return result;
    }

    private static Map readMapType(Class<?> type, String configKey, Properties properties, Type keyType, Type valueType) {
        Objects.requireNonNull(configKey);
        Objects.requireNonNull(properties);
        Map<Object, Object> map = ConfigInitializer.initEmptyMap(type);
        String prefix = configKey + "[";
        String suffix = "]";
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(propertyKey, propertyValue) -> {
            String propertyStringKey = propertyKey.toString();
            if (propertyStringKey.startsWith(prefix) && propertyStringKey.endsWith(suffix)) {
                String itemKey = propertyStringKey.substring(prefix.length(), propertyStringKey.length() - suffix.length());
                Object keyObj = ConfigInitializer.convertToTypicalType(keyType, itemKey);
                Object valueObj = ConfigInitializer.convertToTypicalType(valueType, propertyValue.toString());
                if (keyObj == null) {
                    keyObj = itemKey;
                }
                if (valueObj == null) {
                    valueObj = propertyValue;
                }
                map.put(keyObj, valueObj);
            }
        }));
        return map;
    }

    private static Map<Object, Object> initEmptyMap(Class<?> type) {
        if (type.equals(Map.class) || type.equals(HashMap.class)) {
            return new HashMap<Object, Object>();
        }
        if (type.equals(TreeMap.class)) {
            return new TreeMap<Object, Object>();
        }
        throw new UnsupportedOperationException("Config parameter type support Map,HashMap,TreeMap");
    }
}

