/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.protocol.AbstractMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.Decompressor;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.common.stream.StreamDecoderInput;
import com.linecorp.armeria.internal.common.grpc.protocol.Base64Decoder;
import com.linecorp.armeria.internal.common.stream.ByteBufsDecoderInput;
import com.linecorp.armeria.server.grpc.UnaryDecoderInput;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.List;

final class UnaryMessageDeframer
extends AbstractMessageDeframer {
    private final ByteBufAllocator alloc;
    @Nullable
    private final Base64Decoder base64Decoder;

    UnaryMessageDeframer(ByteBufAllocator alloc, int maxMessageLength, boolean grpcWebText) {
        super(maxMessageLength);
        this.alloc = alloc;
        this.base64Decoder = grpcWebText ? new Base64Decoder(alloc) : null;
    }

    DeframedMessage deframe(HttpData data) {
        ByteBuf buf = data.byteBuf();
        if (this.base64Decoder != null) {
            buf = this.base64Decoder.decode(buf);
        }
        try (UnaryDecoderInput input = new UnaryDecoderInput(buf);){
            this.readHeader(input);
            DeframedMessage deframedMessage = this.readBody(input);
            return deframedMessage;
        }
    }

    DeframedMessage deframe(List<HttpObject> objects) {
        try (ByteBufsDecoderInput input = new ByteBufsDecoderInput(this.alloc);){
            for (HttpObject object : objects) {
                if (!(object instanceof HttpData)) continue;
                ByteBuf buf = ((HttpData)object).byteBuf();
                if (this.base64Decoder != null) {
                    buf = this.base64Decoder.decode(buf);
                }
                input.add(buf);
            }
            this.readHeader((StreamDecoderInput)input);
            DeframedMessage deframedMessage = this.readBody((StreamDecoderInput)input);
            return deframedMessage;
        }
    }

    protected UnaryMessageDeframer decompressor(@Nullable Decompressor decompressor) {
        return (UnaryMessageDeframer)super.decompressor(decompressor);
    }
}

