/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.query.PaginationUtils;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.event.Event;
import org.apache.skywalking.oap.server.core.query.type.event.EventQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.event.EventType;
import org.apache.skywalking.oap.server.core.query.type.event.Events;
import org.apache.skywalking.oap.server.core.query.type.event.Source;
import org.apache.skywalking.oap.server.core.storage.query.IEventQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.MatchCNameBuilder;

public class ESEventQueryDAO
extends EsDAO
implements IEventQueryDAO {
    public ESEventQueryDAO(ElasticSearchClient client) {
        super(client);
    }

    public Events queryEvents(EventQueryCondition condition) throws Exception {
        SearchBuilder sourceBuilder = this.buildQuery(condition);
        return this.getEventsResultByCurrentBuilder(sourceBuilder);
    }

    public Events queryEvents(List<EventQueryCondition> conditionList) throws Exception {
        SearchBuilder sourceBuilder = this.buildQuery(conditionList);
        return this.getEventsResultByCurrentBuilder(sourceBuilder);
    }

    private Events getEventsResultByCurrentBuilder(SearchBuilder searchBuilder) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("events");
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, searchBuilder.build());
        return new Events(response.getHits().getHits().stream().map(this::parseSearchHit).collect(Collectors.toList()));
    }

    private void buildMustQueryListByCondition(EventQueryCondition condition, BoolQueryBuilder query) {
        Duration startTime;
        Source source;
        if (IndexController.LogicIndicesRegister.isMergedTable("events")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"events"));
        }
        if (!Strings.isNullOrEmpty((String)condition.getUuid())) {
            query.must((QueryBuilder)Query.term((String)"uuid", (Object)condition.getUuid()));
        }
        if ((source = condition.getSource()) != null) {
            if (!Strings.isNullOrEmpty((String)source.getService())) {
                query.must((QueryBuilder)Query.term((String)"service", (Object)source.getService()));
            }
            if (!Strings.isNullOrEmpty((String)source.getServiceInstance())) {
                query.must((QueryBuilder)Query.term((String)"service_instance", (Object)source.getServiceInstance()));
            }
            if (!Strings.isNullOrEmpty((String)source.getEndpoint())) {
                query.must((QueryBuilder)Query.matchPhrase((String)MatchCNameBuilder.INSTANCE.build("endpoint"), (String)source.getEndpoint()));
            }
        }
        if (!Strings.isNullOrEmpty((String)condition.getName())) {
            query.must((QueryBuilder)Query.term((String)"name", (Object)condition.getName()));
        }
        if (condition.getType() != null) {
            query.must((QueryBuilder)Query.term((String)"type", (Object)condition.getType().name()));
        }
        if ((startTime = condition.getTime()) != null) {
            if (startTime.getStartTimestamp() > 0L) {
                query.must((QueryBuilder)Query.range((String)"start_time").gt((Object)startTime.getStartTimestamp()));
            }
            if (startTime.getEndTimestamp() > 0L) {
                query.must((QueryBuilder)Query.range((String)"end_time").lt((Object)startTime.getEndTimestamp()));
            }
        }
        if (!Strings.isNullOrEmpty((String)condition.getLayer())) {
            query.must((QueryBuilder)Query.term((String)"layer", (Object)condition.getLayer()));
        }
    }

    protected SearchBuilder buildQuery(List<EventQueryCondition> conditionList) {
        BoolQueryBuilder query = Query.bool();
        conditionList.forEach(condition -> {
            BoolQueryBuilder bool = Query.bool();
            query.should((QueryBuilder)bool);
            this.buildMustQueryListByCondition((EventQueryCondition)condition, bool);
        });
        EventQueryCondition condition2 = conditionList.get(0);
        Order queryOrder = Objects.isNull(condition2.getOrder()) ? Order.DES : condition2.getOrder();
        PaginationUtils.Page page = PaginationUtils.INSTANCE.exchange(condition2.getPaging());
        return Search.builder().query((QueryBuilder)query).sort("start_time", Order.DES.equals((Object)queryOrder) ? Sort.Order.DESC : Sort.Order.ASC).from(Integer.valueOf(page.getFrom())).size(Integer.valueOf(page.getLimit()));
    }

    protected SearchBuilder buildQuery(EventQueryCondition condition) {
        BoolQueryBuilder query = Query.bool();
        this.buildMustQueryListByCondition(condition, query);
        Order queryOrder = Objects.isNull(condition.getOrder()) ? Order.DES : condition.getOrder();
        PaginationUtils.Page page = PaginationUtils.INSTANCE.exchange(condition.getPaging());
        return Search.builder().query((QueryBuilder)query).sort("start_time", Order.DES.equals((Object)queryOrder) ? Sort.Order.DESC : Sort.Order.ASC).from(Integer.valueOf(page.getFrom())).size(Integer.valueOf(page.getLimit()));
    }

    protected Event parseSearchHit(SearchHit searchHit) {
        Event event = new Event();
        event.setUuid((String)searchHit.getSource().get("uuid"));
        String service = searchHit.getSource().getOrDefault("service", "").toString();
        String serviceInstance = searchHit.getSource().getOrDefault("service_instance", "").toString();
        String endpoint = searchHit.getSource().getOrDefault("endpoint", "").toString();
        event.setSource(new Source(service, serviceInstance, endpoint));
        event.setName((String)searchHit.getSource().get("name"));
        event.setType(EventType.parse((String)searchHit.getSource().get("type").toString()));
        event.setMessage((String)searchHit.getSource().get("message"));
        event.setParameters((String)searchHit.getSource().get("parameters"));
        event.setStartTime(Long.parseLong(searchHit.getSource().get("start_time").toString()));
        String endTimeStr = searchHit.getSource().getOrDefault("end_time", "0").toString();
        if (!endTimeStr.isEmpty() && !Objects.equals(endTimeStr, "0")) {
            event.setEndTime(Long.parseLong(endTimeStr));
        }
        event.setLayer(Layer.valueOf((int)Integer.parseInt(searchHit.getSource().get("layer").toString())).name());
        return event;
    }
}

