/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.enums.ConfigSourceType;
import com.ctrip.framework.apollo.internals.AbstractConfig;
import com.ctrip.framework.apollo.internals.ConfigRepository;
import com.ctrip.framework.apollo.internals.RepositoryChangeListener;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.util.ExceptionUtil;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleConfig
extends AbstractConfig
implements RepositoryChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(SimpleConfig.class);
    private final String m_namespace;
    private final ConfigRepository m_configRepository;
    private volatile Properties m_configProperties;
    private volatile ConfigSourceType m_sourceType = ConfigSourceType.NONE;

    public SimpleConfig(String namespace, ConfigRepository configRepository) {
        this.m_namespace = namespace;
        this.m_configRepository = configRepository;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        try {
            this.updateConfig(this.m_configRepository.getConfig(), this.m_configRepository.getSourceType());
        }
        catch (Throwable ex) {
            Tracer.logError((Throwable)ex);
            logger.warn("Init Apollo Simple Config failed - namespace: {}, reason: {}", (Object)this.m_namespace, (Object)ExceptionUtil.getDetailMessage(ex));
        }
        finally {
            this.m_configRepository.addChangeListener(this);
        }
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        if (this.m_configProperties == null) {
            logger.warn("Could not load config from Apollo, always return default value!");
            return defaultValue;
        }
        return this.m_configProperties.getProperty(key, defaultValue);
    }

    @Override
    public Set<String> getPropertyNames() {
        if (this.m_configProperties == null) {
            return Collections.emptySet();
        }
        return this.m_configProperties.stringPropertyNames();
    }

    @Override
    public ConfigSourceType getSourceType() {
        return this.m_sourceType;
    }

    @Override
    public synchronized void onRepositoryChange(String namespace, Properties newProperties) {
        if (newProperties.equals(this.m_configProperties)) {
            return;
        }
        Properties newConfigProperties = this.propertiesFactory.getPropertiesInstance();
        newConfigProperties.putAll((Map<?, ?>)newProperties);
        List<ConfigChange> changes = this.calcPropertyChanges(namespace, this.m_configProperties, newConfigProperties);
        ImmutableMap changeMap = Maps.uniqueIndex(changes, (Function)new Function<ConfigChange, String>(){

            public String apply(ConfigChange input) {
                return input.getPropertyName();
            }
        });
        this.updateConfig(newConfigProperties, this.m_configRepository.getSourceType());
        this.clearConfigCache();
        this.fireConfigChange(new ConfigChangeEvent(this.m_namespace, (Map<String, ConfigChange>)changeMap));
        Tracer.logEvent((String)"Apollo.Client.ConfigChanges", (String)this.m_namespace);
    }

    private void updateConfig(Properties newConfigProperties, ConfigSourceType sourceType) {
        this.m_configProperties = newConfigProperties;
        this.m_sourceType = sourceType;
    }
}

