/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.register.provider.handler.v8;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.management.v3.InstancePingPkg;
import org.apache.skywalking.apm.network.management.v3.InstanceProperties;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceUpdate;
import org.apache.skywalking.oap.server.core.source.ServiceMeta;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public final class ManagementServiceHandler {
    private final SourceReceiver sourceReceiver;
    private final NamingControl namingControl;

    public ManagementServiceHandler(ModuleManager moduleManager) {
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
    }

    private Layer identifyInstanceLayer(String layer) {
        if (StringUtil.isEmpty((String)layer)) {
            return Layer.GENERAL;
        }
        return Layer.nameOf((String)layer);
    }

    public Commands reportInstanceProperties(InstanceProperties request) {
        ServiceInstanceUpdate serviceInstanceUpdate = new ServiceInstanceUpdate();
        String serviceName = this.namingControl.formatServiceName(request.getService());
        String instanceName = this.namingControl.formatInstanceName(request.getServiceInstance());
        serviceInstanceUpdate.setServiceId(IDManager.ServiceID.buildId((String)serviceName, (boolean)true));
        serviceInstanceUpdate.setName(instanceName);
        JsonObject properties = new JsonObject();
        ArrayList ipv4List = new ArrayList();
        request.getPropertiesList().forEach(prop -> {
            if ("ipv4".equals(prop.getKey())) {
                ipv4List.add(prop.getValue());
            } else {
                properties.addProperty(prop.getKey(), prop.getValue());
            }
        });
        properties.addProperty("ipv4s", String.join((CharSequence)",", ipv4List));
        serviceInstanceUpdate.setProperties(properties);
        serviceInstanceUpdate.setTimeBucket(TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Minute));
        this.sourceReceiver.receive((ISource)serviceInstanceUpdate);
        return Commands.newBuilder().build();
    }

    public Commands keepAlive(InstancePingPkg request) {
        long timeBucket = TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Minute);
        String serviceName = this.namingControl.formatServiceName(request.getService());
        String instanceName = this.namingControl.formatInstanceName(request.getServiceInstance());
        Layer layer = this.identifyInstanceLayer(request.getLayer());
        ServiceInstanceUpdate serviceInstanceUpdate = new ServiceInstanceUpdate();
        serviceInstanceUpdate.setServiceId(IDManager.ServiceID.buildId((String)serviceName, (boolean)true));
        serviceInstanceUpdate.setName(instanceName);
        serviceInstanceUpdate.setTimeBucket(timeBucket);
        this.sourceReceiver.receive((ISource)serviceInstanceUpdate);
        ServiceMeta serviceMeta = new ServiceMeta();
        serviceMeta.setName(serviceName);
        serviceMeta.setTimeBucket(timeBucket);
        serviceMeta.setLayer(layer);
        this.sourceReceiver.receive((ISource)serviceMeta);
        return Commands.newBuilder().build();
    }
}

