/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.banyandb.property.v1.BanyandbProperty;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.PairQueryCondition;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.MetadataCache;

public class PropertyQuery
extends AbstractQuery<BanyandbProperty.QueryRequest> {
    private int limit = 20;
    private List<String> ids = new ArrayList<String>();
    private String nodeSelector;

    public PropertyQuery(List<String> groups, String name, Set<String> projections) {
        super(groups, name, null, projections);
    }

    public PropertyQuery id(String id) {
        if (id != null && !id.isEmpty()) {
            this.ids.add(id);
        }
        return this;
    }

    public PropertyQuery ids(List<String> ids) {
        if (ids != null) {
            this.ids.addAll(ids);
        }
        return this;
    }

    public PropertyQuery nodeSelector(String nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    public PropertyQuery and(PairQueryCondition<?> condition) {
        return (PropertyQuery)super.and(condition);
    }

    public PropertyQuery or(PairQueryCondition<?> condition) {
        return (PropertyQuery)super.or(condition);
    }

    @Override
    BanyandbProperty.QueryRequest build(MetadataCache.EntityMetadata ignored) throws BanyanDBException {
        return this.build();
    }

    public BanyandbProperty.QueryRequest build() throws BanyanDBException {
        BanyandbProperty.QueryRequest.Builder builder = BanyandbProperty.QueryRequest.newBuilder();
        builder.setName(this.name);
        builder.addAllGroups(this.groups);
        builder.addAllTagProjection(this.tagProjections);
        this.buildCriteria().ifPresent(builder::setCriteria);
        builder.setLimit(this.limit);
        builder.setTrace(this.trace);
        if (!this.ids.isEmpty()) {
            builder.addAllIds(this.ids);
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            builder.setNodeSelector(this.nodeSelector);
        }
        return builder.build();
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
    }

    public void setNodeSelector(String nodeSelector) {
        this.nodeSelector = nodeSelector;
    }
}

