/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.postgresql;

import com.google.gson.JsonObject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.JDBCTableInstaller;

public class PostgreSQLTableInstaller
extends JDBCTableInstaller {
    public PostgreSQLTableInstaller(Client client, ModuleManager moduleManager) {
        super(client, moduleManager);
    }

    public void start() {
        this.overrideColumnName("value", "value_");
        this.overrideColumnName("precision", "cal_precision");
        this.overrideColumnName("match", "match_num");
    }

    @Override
    protected String getColumnDefinition(ModelColumn column, Class<?> type, Type genericType) {
        String storageName = column.getColumnName().getStorageName();
        if (Integer.class.equals(type) || Integer.TYPE.equals(type) || Layer.class.equals(type)) {
            return storageName + " INT";
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return storageName + " BIGINT";
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return storageName + " DOUBLE PRECISION";
        }
        if (String.class.equals(type)) {
            return storageName + " VARCHAR(" + column.getLength() + ")";
        }
        if (StorageDataComplexObject.class.isAssignableFrom(type)) {
            return storageName + " VARCHAR(20000)";
        }
        if (byte[].class.equals(type)) {
            return storageName + " TEXT";
        }
        if (JsonObject.class.equals(type)) {
            if (column.getLength() > 16383) {
                return storageName + " TEXT";
            }
            return storageName + " VARCHAR(" + column.getLength() + ")";
        }
        if (List.class.isAssignableFrom(type)) {
            Type elementType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            return this.getColumnDefinition(column, (Class)elementType, elementType);
        }
        throw new IllegalArgumentException("Unsupported data type: " + type.getName());
    }

    @Override
    public String getColumnDefinition(ModelColumn column) {
        String storageName = column.getColumnName().getStorageName();
        Class type = column.getType();
        if (StorageDataComplexObject.class.isAssignableFrom(type)) {
            return storageName + " TEXT";
        }
        if (String.class.equals((Object)type)) {
            if (column.getLength() > 16383) {
                return storageName + " TEXT";
            }
            return storageName + " VARCHAR(" + column.getLength() + ")";
        }
        if (JsonObject.class.equals((Object)type)) {
            if (column.getLength() > 16383) {
                return storageName + " TEXT";
            }
            return storageName + " VARCHAR(" + column.getLength() + ")";
        }
        return super.getColumnDefinition(column);
    }
}

