/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.endpoint;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.Attributes;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.fastutil.ints.Int2ObjectOpenHashMap;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.util.AttributeKey;
import java.util.Map;
import java.util.Objects;

public final class EndpointAttributeKeys {
    public static final AttributeKey<Long> CREATED_AT_NANOS_KEY = AttributeKey.valueOf(EndpointAttributeKeys.class, "createdAtNanos");
    public static final AttributeKey<Boolean> HEALTHY_ATTR = AttributeKey.valueOf(EndpointAttributeKeys.class, "HEALTHY");
    public static final AttributeKey<Boolean> DEGRADED_ATTR = AttributeKey.valueOf(EndpointAttributeKeys.class, "DEGRADED");
    private static final Map<Integer, Attributes> attributesCache = new Int2ObjectOpenHashMap<Attributes>();

    public static long createdAtNanos(Endpoint endpoint) {
        Long createdAtNanos = endpoint.attr(CREATED_AT_NANOS_KEY);
        Preconditions.checkState(createdAtNanos != null, "createdAtNanos doesn't exist for '%s'", endpoint);
        return createdAtNanos;
    }

    public static boolean hasCreatedAtNanos(Endpoint endpoint) {
        return endpoint.attr(CREATED_AT_NANOS_KEY) != null;
    }

    @Nullable
    public static Boolean healthy(Endpoint endpoint) {
        return endpoint.attr(HEALTHY_ATTR);
    }

    @Nullable
    public static Boolean degraded(Endpoint endpoint) {
        return endpoint.attr(DEGRADED_ATTR);
    }

    public static Attributes healthCheckAttributes(boolean healthy, boolean degraded) {
        int key = 0;
        if (healthy) {
            ++key;
        }
        if (degraded) {
            key += 2;
        }
        Attributes attributes = attributesCache.get(key);
        assert (attributes != null);
        return attributes;
    }

    public static boolean equalHealthCheckAttributes(Endpoint endpoint1, Endpoint endpoint2) {
        return Objects.equals(endpoint1.attr(HEALTHY_ATTR), endpoint2.attr(HEALTHY_ATTR)) && Objects.equals(endpoint1.attr(DEGRADED_ATTR), endpoint2.attr(DEGRADED_ATTR));
    }

    private EndpointAttributeKeys() {
    }

    static {
        attributesCache.put(0, Attributes.of(HEALTHY_ATTR, false, DEGRADED_ATTR, false));
        attributesCache.put(1, Attributes.of(HEALTHY_ATTR, true, DEGRADED_ATTR, false));
        attributesCache.put(2, Attributes.of(HEALTHY_ATTR, false, DEGRADED_ATTR, true));
        attributesCache.put(3, Attributes.of(HEALTHY_ATTR, true, DEGRADED_ATTR, true));
    }
}

