/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.BuiltInProperties;
import com.linecorp.armeria.common.logging.BuiltInProperty;
import com.linecorp.armeria.common.logging.ExportGroupBuilder;
import com.linecorp.armeria.common.logging.RequestContextExporterBuilder;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAccess;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.internal.shaded.fastutil.objects.Object2ObjectOpenHashMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.netty.util.AsciiString;
import io.netty.util.AttributeKey;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public final class RequestContextExporter {
    private static final ExportGroupBuilder.ExportEntry[] EMPTY_EXPORT_ENTRIES = new ExportGroupBuilder.ExportEntry[0];
    private static final AtomicLong EXPORTER_ID_GENERATOR = new AtomicLong();
    final AttributeKey<State> stateAttributeKey = AttributeKey.valueOf(RequestContextExporter.class, "STATE_" + EXPORTER_ID_GENERATOR.incrementAndGet());
    @Nullable
    private final BuiltInProperties builtInProperties;
    @Nullable
    private final ExportGroupBuilder.ExportEntry<BuiltInProperty>[] builtInPropertyArray;
    @Nullable
    private final ExportGroupBuilder.ExportEntry<AttributeKey<?>>[] attrs;
    private final int numAttrs;
    @Nullable
    private final ExportGroupBuilder.ExportEntry<AsciiString>[] reqHeaders;
    @Nullable
    private final ExportGroupBuilder.ExportEntry<AsciiString>[] resHeaders;

    public static RequestContextExporterBuilder builder() {
        return new RequestContextExporterBuilder();
    }

    RequestContextExporter(Set<ExportGroupBuilder.ExportEntry<BuiltInProperty>> builtInPropertySet, Set<ExportGroupBuilder.ExportEntry<AttributeKey<?>>> attrs, Set<ExportGroupBuilder.ExportEntry<AsciiString>> reqHeaders, Set<ExportGroupBuilder.ExportEntry<AsciiString>> resHeaders) {
        if (!builtInPropertySet.isEmpty()) {
            this.builtInProperties = new BuiltInProperties();
            for (ExportGroupBuilder.ExportEntry<BuiltInProperty> entry : this.builtInPropertyArray = builtInPropertySet.toArray(EMPTY_EXPORT_ENTRIES)) {
                this.builtInProperties.add((BuiltInProperty)((Object)entry.key));
            }
        } else {
            this.builtInProperties = null;
            this.builtInPropertyArray = null;
        }
        if (!attrs.isEmpty()) {
            this.attrs = attrs.toArray(EMPTY_EXPORT_ENTRIES);
            this.numAttrs = this.attrs.length;
        } else {
            this.attrs = null;
            this.numAttrs = 0;
        }
        this.reqHeaders = !reqHeaders.isEmpty() ? reqHeaders.toArray(EMPTY_EXPORT_ENTRIES) : null;
        this.resHeaders = !resHeaders.isEmpty() ? resHeaders.toArray(EMPTY_EXPORT_ENTRIES) : null;
    }

    public boolean containsAttribute(AttributeKey<?> key) {
        Objects.requireNonNull(key, "key");
        if (this.attrs == null) {
            return false;
        }
        return Arrays.stream(this.attrs).anyMatch(e -> ((AttributeKey)e.key).equals(key));
    }

    public boolean containsRequestHeader(CharSequence name) {
        Objects.requireNonNull(name, "name");
        if (this.reqHeaders == null) {
            return false;
        }
        return Arrays.stream(this.reqHeaders).anyMatch(e -> ((AsciiString)e.key).contentEqualsIgnoreCase(name));
    }

    public boolean containsResponseHeader(CharSequence name) {
        Objects.requireNonNull(name, "name");
        if (this.resHeaders == null) {
            return false;
        }
        return Arrays.stream(this.resHeaders).anyMatch(e -> ((AsciiString)e.key).contentEqualsIgnoreCase(name));
    }

    public boolean containsBuiltIn(BuiltInProperty property) {
        Objects.requireNonNull(property, "property");
        if (this.builtInProperties == null) {
            return false;
        }
        return this.builtInProperties.contains(property);
    }

    public Set<BuiltInProperty> builtIns() {
        if (this.builtInPropertyArray == null) {
            return ImmutableSet.of();
        }
        return Arrays.stream(this.builtInPropertyArray).map(entry -> (BuiltInProperty)((Object)((Object)entry.key))).collect(ImmutableSet.toImmutableSet());
    }

    public Map<String, AttributeKey<?>> attributes() {
        if (this.attrs == null) {
            return ImmutableMap.of();
        }
        return Arrays.stream(this.attrs).collect(ImmutableMap.toImmutableMap(e -> e.exportKey, e -> (AttributeKey)e.key));
    }

    public Set<AsciiString> requestHeaders() {
        if (this.reqHeaders == null) {
            return ImmutableSet.of();
        }
        return Arrays.stream(this.reqHeaders).map(e -> (AsciiString)e.key).collect(ImmutableSet.toImmutableSet());
    }

    public Set<AsciiString> responseHeaders() {
        if (this.resHeaders == null) {
            return ImmutableSet.of();
        }
        return Arrays.stream(this.resHeaders).map(e -> (AsciiString)e.key).collect(ImmutableSet.toImmutableSet());
    }

    public Map<String, String> export() {
        Object ctx = RequestContext.currentOrNull();
        return ctx != null ? this.export((RequestContext)ctx) : ImmutableMap.of();
    }

    public Map<String, String> export(RequestContext ctx) {
        Objects.requireNonNull(ctx, "ctx");
        State state = this.state(ctx);
        RequestLogAccess log = ctx.log();
        boolean needsUpdate = false;
        int availabilityStamp = log.availabilityStamp();
        if (state.availabilityStamp != availabilityStamp) {
            state.availabilityStamp = availabilityStamp;
            needsUpdate = true;
        }
        if (this.attrs != null) {
            assert (state.attrValues != null);
            for (int i = 0; i < this.attrs.length; ++i) {
                Object newValue = ctx.attr((AttributeKey)this.attrs[i].key);
                if (!needsUpdate) {
                    Object oldValue = state.attrValues[i];
                    needsUpdate = !Objects.equals(oldValue, newValue);
                }
                state.attrValues[i] = newValue;
            }
        }
        if (needsUpdate) {
            this.export(state, log.partial());
        }
        return state.clone();
    }

    private void export(State state, RequestLog log) {
        this.exportBuiltIns(state, log);
        this.exportAttributes(state);
        this.exportRequestHeaders(state, log);
        this.exportResponseHeaders(state, log);
    }

    private void exportBuiltIns(State state, RequestLog log) {
        if (this.builtInPropertyArray != null) {
            for (ExportGroupBuilder.ExportEntry<BuiltInProperty> entry : this.builtInPropertyArray) {
                String value = ((BuiltInProperty)((Object)entry.key)).converter.apply(log);
                if (value == null) continue;
                state.put(entry.exportKey, value);
            }
        }
    }

    private void exportAttributes(State state) {
        if (this.attrs == null) {
            return;
        }
        assert (state.attrValues != null);
        for (int i = 0; i < this.numAttrs; ++i) {
            ExportGroupBuilder.ExportEntry<AttributeKey<?>> e = this.attrs[i];
            RequestContextExporter.putStringifiedProperty(state, e, state.attrValues[i]);
        }
    }

    private void exportRequestHeaders(State state, RequestLog log) {
        if (this.reqHeaders == null || !log.isAvailable(RequestLogProperty.REQUEST_HEADERS)) {
            return;
        }
        RequestContextExporter.exportHeaders(state, log.requestHeaders(), this.reqHeaders);
    }

    private void exportResponseHeaders(State state, RequestLog log) {
        if (this.resHeaders == null || !log.isAvailable(RequestLogProperty.RESPONSE_HEADERS)) {
            return;
        }
        RequestContextExporter.exportHeaders(state, log.responseHeaders(), this.resHeaders);
    }

    private static void exportHeaders(State state, HttpHeaders headers, ExportGroupBuilder.ExportEntry<AsciiString>[] requiredHeaderNames) {
        for (ExportGroupBuilder.ExportEntry<AsciiString> e : requiredHeaderNames) {
            RequestContextExporter.putStringifiedProperty(state, e, headers.get((CharSequence)e.key));
        }
    }

    private static void putStringifiedProperty(State state, ExportGroupBuilder.ExportEntry<?> entry, @Nullable Object value) {
        String valueStr;
        if (value != null && (valueStr = entry.stringify(value)) != null) {
            state.put(entry.exportKey, valueStr);
            return;
        }
        state.remove(entry.exportKey);
    }

    private State state(RequestContext ctx) {
        State state = ctx.ownAttr(this.stateAttributeKey);
        if (state != null) {
            return state;
        }
        State newState = new State(this.numAttrs);
        ctx.setAttr(this.stateAttributeKey, newState);
        return newState;
    }

    private static final class State
    extends Object2ObjectOpenHashMap<String, String> {
        private static final long serialVersionUID = -7084248226635055988L;
        int availabilityStamp = -1;
        @Nullable
        final Object[] attrValues;

        State(int numAttrs) {
            this.attrValues = numAttrs != 0 ? new Object[numAttrs] : null;
        }
    }
}

